/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.tools.cli.commands.bookie;

import java.util.concurrent.ExecutionException;
import org.apache.pulsar.shade.com.beust.jcommander.Parameter;
import org.apache.pulsar.shade.com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.Bookie;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.Cookie;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.exceptions.MetadataException;
import org.apache.pulsar.shade.org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import org.apache.pulsar.shade.org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.pulsar.shade.org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.pulsar.shade.org.apache.bookkeeper.versioning.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatCommand
extends BookieCommand<Flags> {
    static final Logger LOG = LoggerFactory.getLogger(FormatCommand.class);
    private static final String NAME = "format";
    private static final String DESC = "Format the current server contents.";

    public FormatCommand() {
        this(new Flags());
    }

    public FormatCommand(Flags flags) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags(flags).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, Flags cmdFlags) {
        ServerConfiguration bfconf = new ServerConfiguration(conf);
        boolean result = Bookie.format(bfconf, cmdFlags.nonInteractive, cmdFlags.force);
        if (cmdFlags.deleteCookie) {
            try {
                MetadataDrivers.runFunctionWithRegistrationManager(conf, rm -> {
                    try {
                        Versioned<Cookie> cookie = Cookie.readFromRegistrationManager(rm, bfconf);
                        cookie.getValue().deleteFromRegistrationManager((RegistrationManager)rm, bfconf, cookie.getVersion());
                    }
                    catch (Exception e) {
                        throw new UncheckedExecutionException(e.getMessage(), e);
                    }
                    return null;
                });
            }
            catch (ExecutionException | MetadataException e) {
                throw new UncheckedExecutionException(e.getMessage(), e);
            }
        }
        return result;
    }

    public static class Flags
    extends CliFlags {
        @Parameter(names={"-n", "--noninteractive"}, description="Whether to confirm if old data exists?")
        private boolean nonInteractive;
        @Parameter(names={"-f", "--force"}, description="If [noninteractive] is specified, then whetherto force delete the old data without prompt?")
        private boolean force;
        @Parameter(names={"-d", "--deletecookie"}, description="Delete its cookie on metadata store.")
        private boolean deleteCookie;

        public Flags nonInteractive(boolean nonInteractive) {
            this.nonInteractive = nonInteractive;
            return this;
        }

        public Flags force(boolean force) {
            this.force = force;
            return this;
        }

        public Flags deleteCookie(boolean deleteCookie) {
            this.deleteCookie = deleteCookie;
            return this;
        }
    }
}

