/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.util;

import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SnapshotMap<K, V> {
    volatile Map<K, V> updates;
    volatile Map<K, V> updatesToMerge;
    volatile NavigableMap<K, V> snapshot;
    final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public SnapshotMap() {
        this.updates = new ConcurrentHashMap();
        this.updatesToMerge = new ConcurrentHashMap();
        this.snapshot = new ConcurrentSkipListMap();
    }

    public NavigableMap<K, V> snapshot() {
        this.lock.writeLock().lock();
        try {
            if (this.updates.isEmpty()) {
                NavigableMap<K, V> navigableMap = this.snapshot;
                return navigableMap;
            }
            this.updatesToMerge = this.updates;
            this.updates = new ConcurrentHashMap();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        for (Map.Entry<K, V> entry : this.updatesToMerge.entrySet()) {
            this.snapshot.put(entry.getKey(), entry.getValue());
        }
        this.lock.writeLock().lock();
        try {
            this.updatesToMerge = new ConcurrentHashMap();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return this.snapshot;
    }

    public void put(K key, V value) {
        this.lock.readLock().lock();
        try {
            this.updates.put(key, value);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void remove(K key) {
        this.lock.readLock().lock();
        try {
            this.updates.remove(key);
            this.updatesToMerge.remove(key);
            this.snapshot.remove(key);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean containsKey(K key) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.updates.containsKey(key) | this.updatesToMerge.containsKey(key) | this.snapshot.containsKey(key);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

