/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.util.collections;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import org.apache.pulsar.shade.org.apache.commons.lang3.tuple.Pair;

public class SynchronizedHashMultiMap<K, V> {
    HashMap<Integer, Set<Pair<K, V>>> map = new HashMap();

    public synchronized void put(K k, V v) {
        this.map.computeIfAbsent(k.hashCode(), ignore -> new HashSet()).add(Pair.of(k, v));
    }

    public synchronized Optional<K> getAnyKey() {
        return this.map.values().stream().findAny().flatMap(pairs -> pairs.stream().findAny().map(p -> p.getLeft()));
    }

    public synchronized Optional<V> removeAny(K k) {
        Set set = this.map.getOrDefault(k.hashCode(), Collections.emptySet());
        Optional<Pair> pair = set.stream().filter(p -> p.getLeft().equals(k)).findAny();
        pair.ifPresent(p -> set.remove(p));
        return pair.map(p -> p.getRight());
    }

    public synchronized int removeIf(BiPredicate<K, V> predicate) {
        int removedSum = this.map.values().stream().mapToInt(pairs -> {
            int removed = 0;
            Iterator iter = pairs.iterator();
            while (iter.hasNext()) {
                Pair kv = (Pair)iter.next();
                if (!predicate.test(kv.getLeft(), kv.getRight())) continue;
                iter.remove();
                ++removed;
            }
            return removed;
        }).sum();
        this.map.values().removeIf((? super E s) -> s.isEmpty());
        return removedSum;
    }
}

