/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.api.proto;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.ClusterMessageId;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.LightProtoCodec;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.MarkersMessageIdData;

public final class ReplicatedSubscriptionsSnapshot {
    private String snapshotId;
    private int _snapshotIdBufferIdx = -1;
    private int _snapshotIdBufferLen = -1;
    private static final int _SNAPSHOT_ID_FIELD_NUMBER = 1;
    private static final int _SNAPSHOT_ID_TAG = 10;
    private static final int _SNAPSHOT_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(10);
    private static final int _SNAPSHOT_ID_MASK = 1;
    private MarkersMessageIdData localMessageId;
    private static final int _LOCAL_MESSAGE_ID_FIELD_NUMBER = 2;
    private static final int _LOCAL_MESSAGE_ID_TAG = 18;
    private static final int _LOCAL_MESSAGE_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(18);
    private static final int _LOCAL_MESSAGE_ID_MASK = 2;
    private List<ClusterMessageId> clusters = null;
    private int _clustersCount = 0;
    private static final int _CLUSTERS_FIELD_NUMBER = 3;
    private static final int _CLUSTERS_TAG = 26;
    private static final int _CLUSTERS_TAG_SIZE = LightProtoCodec.computeVarIntSize(26);
    private int _bitField0;
    private static final int _REQUIRED_FIELDS_MASK0 = 1;
    private int _cachedSize;
    private ByteBuf _parsedBuffer;

    public boolean hasSnapshotId() {
        return (this._bitField0 & 1) != 0;
    }

    public String getSnapshotId() {
        if (!this.hasSnapshotId()) {
            throw new IllegalStateException("Field 'snapshot_id' is not set");
        }
        if (this.snapshotId == null) {
            this.snapshotId = LightProtoCodec.readString(this._parsedBuffer, this._snapshotIdBufferIdx, this._snapshotIdBufferLen);
        }
        return this.snapshotId;
    }

    public ReplicatedSubscriptionsSnapshot setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
        this._bitField0 |= 1;
        this._snapshotIdBufferIdx = -1;
        this._snapshotIdBufferLen = LightProtoCodec.computeStringUTF8Size(snapshotId);
        this._cachedSize = -1;
        return this;
    }

    public ReplicatedSubscriptionsSnapshot clearSnapshotId() {
        this._bitField0 &= 0xFFFFFFFE;
        this.snapshotId = null;
        this._snapshotIdBufferIdx = -1;
        this._snapshotIdBufferLen = -1;
        return this;
    }

    public boolean hasLocalMessageId() {
        return (this._bitField0 & 2) != 0;
    }

    public MarkersMessageIdData getLocalMessageId() {
        if (!this.hasLocalMessageId()) {
            throw new IllegalStateException("Field 'local_message_id' is not set");
        }
        return this.localMessageId;
    }

    public MarkersMessageIdData setLocalMessageId() {
        if (this.localMessageId == null) {
            this.localMessageId = new MarkersMessageIdData();
        }
        this._bitField0 |= 2;
        this._cachedSize = -1;
        return this.localMessageId;
    }

    public ReplicatedSubscriptionsSnapshot clearLocalMessageId() {
        this._bitField0 &= 0xFFFFFFFD;
        if (this.hasLocalMessageId()) {
            this.localMessageId.clear();
        }
        return this;
    }

    public int getClustersCount() {
        return this._clustersCount;
    }

    public ClusterMessageId getClusterAt(int idx) {
        if (idx < 0 || idx >= this._clustersCount) {
            throw new IndexOutOfBoundsException("Index " + idx + " is out of the list size (" + this._clustersCount + ") for field 'clusters'");
        }
        return this.clusters.get(idx);
    }

    public List<ClusterMessageId> getClustersList() {
        if (this._clustersCount == 0) {
            return Collections.emptyList();
        }
        return this.clusters.subList(0, this._clustersCount);
    }

    public ClusterMessageId addCluster() {
        if (this.clusters == null) {
            this.clusters = new ArrayList<ClusterMessageId>();
        }
        if (this.clusters.size() == this._clustersCount) {
            this.clusters.add(new ClusterMessageId());
        }
        this._cachedSize = -1;
        return this.clusters.get(this._clustersCount++);
    }

    public ReplicatedSubscriptionsSnapshot addAllClusters(Iterable<ClusterMessageId> clusters) {
        for (ClusterMessageId _o : clusters) {
            this.addCluster().copyFrom(_o);
        }
        return this;
    }

    public ReplicatedSubscriptionsSnapshot clearClusters() {
        for (int i = 0; i < this._clustersCount; ++i) {
            this.clusters.get(i).clear();
        }
        this._clustersCount = 0;
        return this;
    }

    public int writeTo(ByteBuf _b) {
        this.checkRequiredFields();
        int _writeIdx = _b.writerIndex();
        LightProtoCodec.writeVarInt(_b, 10);
        LightProtoCodec.writeVarInt(_b, this._snapshotIdBufferLen);
        if (this._snapshotIdBufferIdx == -1) {
            LightProtoCodec.writeString(_b, this.snapshotId, this._snapshotIdBufferLen);
        } else {
            this._parsedBuffer.getBytes(this._snapshotIdBufferIdx, _b, this._snapshotIdBufferLen);
        }
        if (this.hasLocalMessageId()) {
            LightProtoCodec.writeVarInt(_b, 18);
            LightProtoCodec.writeVarInt(_b, this.localMessageId.getSerializedSize());
            this.localMessageId.writeTo(_b);
        }
        for (int i = 0; i < this._clustersCount; ++i) {
            ClusterMessageId _item = this.clusters.get(i);
            LightProtoCodec.writeVarInt(_b, 26);
            LightProtoCodec.writeVarInt(_b, _item.getSerializedSize());
            _item.writeTo(_b);
        }
        return _b.writerIndex() - _writeIdx;
    }

    public int getSerializedSize() {
        if (this._cachedSize > -1) {
            return this._cachedSize;
        }
        int _size = 0;
        _size += _SNAPSHOT_ID_TAG_SIZE;
        _size += LightProtoCodec.computeVarIntSize(this._snapshotIdBufferLen);
        _size += this._snapshotIdBufferLen;
        if (this.hasLocalMessageId()) {
            _size += LightProtoCodec.computeVarIntSize(18);
            int MsgsizeLocalMessageId = this.localMessageId.getSerializedSize();
            _size += LightProtoCodec.computeVarIntSize(MsgsizeLocalMessageId) + MsgsizeLocalMessageId;
        }
        for (int i = 0; i < this._clustersCount; ++i) {
            ClusterMessageId _item = this.clusters.get(i);
            _size += _CLUSTERS_TAG_SIZE;
            int MsgsizeClusters = _item.getSerializedSize();
            _size += LightProtoCodec.computeVarIntSize(MsgsizeClusters) + MsgsizeClusters;
        }
        this._cachedSize = _size;
        return _size;
    }

    public void parseFrom(ByteBuf _buffer, int _size) {
        this.clear();
        int _endIdx = _buffer.readerIndex() + _size;
        block5: while (_buffer.readerIndex() < _endIdx) {
            int _tag = LightProtoCodec.readVarInt(_buffer);
            switch (_tag) {
                case 10: {
                    this._bitField0 |= 1;
                    this._snapshotIdBufferLen = LightProtoCodec.readVarInt(_buffer);
                    this._snapshotIdBufferIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._snapshotIdBufferLen);
                    continue block5;
                }
                case 18: {
                    this._bitField0 |= 2;
                    int localMessageIdSize = LightProtoCodec.readVarInt(_buffer);
                    this.setLocalMessageId().parseFrom(_buffer, localMessageIdSize);
                    continue block5;
                }
                case 26: {
                    int _clustersSize = LightProtoCodec.readVarInt(_buffer);
                    this.addCluster().parseFrom(_buffer, _clustersSize);
                    continue block5;
                }
            }
            LightProtoCodec.skipUnknownField(_tag, _buffer);
        }
        this.checkRequiredFields();
        this._parsedBuffer = _buffer;
    }

    private void checkRequiredFields() {
        if ((this._bitField0 & 1) != 1) {
            throw new IllegalStateException("Some required fields are missing");
        }
    }

    public ReplicatedSubscriptionsSnapshot clear() {
        this.snapshotId = null;
        this._snapshotIdBufferIdx = -1;
        this._snapshotIdBufferLen = -1;
        if (this.hasLocalMessageId()) {
            this.localMessageId.clear();
        }
        for (int i = 0; i < this._clustersCount; ++i) {
            this.clusters.get(i).clear();
        }
        this._clustersCount = 0;
        this._parsedBuffer = null;
        this._cachedSize = -1;
        this._bitField0 = 0;
        return this;
    }

    public ReplicatedSubscriptionsSnapshot copyFrom(ReplicatedSubscriptionsSnapshot _other) {
        this._cachedSize = -1;
        if (_other.hasSnapshotId()) {
            this.setSnapshotId(_other.getSnapshotId());
        }
        if (_other.hasLocalMessageId()) {
            this.setLocalMessageId().copyFrom(_other.localMessageId);
        }
        for (int i = 0; i < _other.getClustersCount(); ++i) {
            this.addCluster().copyFrom(_other.getClusterAt(i));
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] a = new byte[this.getSerializedSize()];
        ByteBuf b = Unpooled.wrappedBuffer(a).writerIndex(0);
        this.writeTo(b);
        return a;
    }

    public void parseFrom(byte[] a) {
        ByteBuf b = Unpooled.wrappedBuffer(a);
        this.parseFrom(b, b.readableBytes());
    }
}

