/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.util;

import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;

public class CompletableFutureCancellationHandler {
    private volatile CompletionStatus completionStatus = CompletionStatus.PENDING;
    private volatile Runnable cancelAction;
    private final AtomicBoolean cancelHandled = new AtomicBoolean();
    private boolean attached;

    public <T> CompletableFuture<T> createFuture() {
        CompletableFuture future = new CompletableFuture();
        this.attachToFuture(future);
        return future;
    }

    public synchronized void attachToFuture(CompletableFuture<?> future) {
        if (this.attached) {
            throw new IllegalStateException("A future has already been attached to this instance.");
        }
        this.attached = true;
        future.whenComplete(this.whenCompleteFunction());
    }

    public void setCancelAction(Runnable cancelAction) {
        if (this.cancelAction != null || this.cancelHandled.get()) {
            throw new IllegalStateException("cancelAction can only be set once.");
        }
        this.cancelAction = Objects.requireNonNull(cancelAction);
        this.runCancelActionOnceIfCancelled();
    }

    private BiConsumer<Object, ? super Throwable> whenCompleteFunction() {
        return (v, throwable) -> {
            this.completionStatus = throwable instanceof CancellationException || throwable instanceof TimeoutException ? CompletionStatus.CANCELLED : CompletionStatus.DONE;
            this.runCancelActionOnceIfCancelled();
        };
    }

    private void runCancelActionOnceIfCancelled() {
        if (this.completionStatus != CompletionStatus.PENDING && this.cancelAction != null && this.cancelHandled.compareAndSet(false, true)) {
            if (this.completionStatus == CompletionStatus.CANCELLED) {
                this.cancelAction.run();
            }
            this.cancelAction = null;
        }
    }

    private static enum CompletionStatus {
        PENDING,
        CANCELLED,
        DONE;

    }
}

