/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.pulsar.broker.service.schema.SchemaStorageFormat;
import org.apache.pulsar.shade.com.beust.jcommander.JCommander;
import org.apache.pulsar.shade.com.beust.jcommander.Parameter;
import org.apache.pulsar.shade.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.BKException;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.BookKeeper;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedLedgerFactory;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryImpl;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.shade.org.apache.zookeeper.KeeperException;
import org.apache.pulsar.shade.org.apache.zookeeper.ZKUtil;
import org.apache.pulsar.shade.org.apache.zookeeper.ZooKeeper;
import org.apache.pulsar.zookeeper.ZooKeeperClientFactory;
import org.apache.pulsar.zookeeper.ZookeeperClientFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarClusterMetadataTeardown {
    public static String[] localZkNodes = new String[]{"bookies", "counters", "loadbalance", "managed-ledgers", "namespace", "schemas", "stream"};
    private static final Logger log = LoggerFactory.getLogger(PulsarClusterMetadataTeardown.class);

    public static void main(String[] args) throws Exception {
        Arguments arguments = new Arguments();
        JCommander jcommander = new JCommander();
        try {
            jcommander.addObject(arguments);
            jcommander.parse(args);
            if (arguments.help) {
                jcommander.usage();
                return;
            }
        }
        catch (Exception e) {
            jcommander.usage();
            throw e;
        }
        if (arguments.bkMetadataServiceUri != null) {
            BookKeeper bookKeeper = new BookKeeper((ClientConfiguration)new ClientConfiguration().setMetadataServiceUri(arguments.bkMetadataServiceUri));
            ZooKeeper zooKeeper = PulsarClusterMetadataTeardown.initZk(arguments.zookeeper, arguments.zkSessionTimeoutMillis);
            ManagedLedgerFactoryImpl managedLedgerFactory = new ManagedLedgerFactoryImpl(bookKeeper, zooKeeper);
            PulsarClusterMetadataTeardown.deleteManagedLedgers(zooKeeper, managedLedgerFactory);
            PulsarClusterMetadataTeardown.deleteSchemaLedgers(zooKeeper, bookKeeper);
            managedLedgerFactory.shutdown();
            bookKeeper.close();
        }
        ZooKeeper localZk = PulsarClusterMetadataTeardown.initZk(arguments.zookeeper, arguments.zkSessionTimeoutMillis);
        for (String localZkNode : localZkNodes) {
            PulsarClusterMetadataTeardown.deleteZkNodeRecursively(localZk, "/" + localZkNode);
        }
        if (arguments.configurationStore != null && arguments.cluster != null) {
            ZooKeeper zooKeeper = PulsarClusterMetadataTeardown.initZk(arguments.configurationStore, arguments.zkSessionTimeoutMillis);
            PulsarClusterMetadataTeardown.deleteZkNodeRecursively(zooKeeper, "/admin/clusters/" + arguments.cluster);
            zooKeeper.close();
        }
        localZk.close();
        log.info("Cluster metadata for '{}' teardown.", (Object)arguments.cluster);
    }

    public static ZooKeeper initZk(String connection, int sessionTimeout) throws InterruptedException {
        ZookeeperClientFactoryImpl zkFactory = new ZookeeperClientFactoryImpl();
        try {
            return zkFactory.create(connection, ZooKeeperClientFactory.SessionType.ReadWrite, sessionTimeout).get();
        }
        catch (ExecutionException e) {
            log.error("Failed to connect to '{}': {}", (Object)connection, (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static void deleteZkNodeRecursively(ZooKeeper zooKeeper, String path) throws InterruptedException {
        try {
            ZKUtil.deleteRecursive(zooKeeper, path);
        }
        catch (KeeperException e) {
            log.warn("Failed to delete node {} from ZK [{}]: {}", new Object[]{path, zooKeeper, e});
        }
    }

    private static List<String> getChildren(ZooKeeper zooKeeper, String path) {
        try {
            return zooKeeper.getChildren(path, null);
        }
        catch (InterruptedException | KeeperException e) {
            if (e instanceof KeeperException.NoNodeException) {
                return new ArrayList<String>();
            }
            log.error("Failed to get children of {}: {}", (Object)path, (Object)e);
            throw new RuntimeException(e);
        }
    }

    private static byte[] getData(ZooKeeper zooKeeper, String path) {
        try {
            return zooKeeper.getData(path, null, null);
        }
        catch (InterruptedException | KeeperException e) {
            log.error("Failed to get data from {}: {}", (Object)path, (Object)e);
            throw new RuntimeException(e);
        }
    }

    private static void deleteLedger(BookKeeper bookKeeper, long ledgerId) {
        try {
            bookKeeper.deleteLedger(ledgerId);
            if (log.isDebugEnabled()) {
                log.debug("Delete ledger id: {}", (Object)ledgerId);
            }
        }
        catch (InterruptedException | BKException e) {
            log.error("Failed to delete ledger {}: {}", (Object)ledgerId, (Object)e);
            throw new RuntimeException(e);
        }
    }

    private static void deleteManagedLedgers(ZooKeeper zooKeeper, ManagedLedgerFactory managedLedgerFactory) {
        String managedLedgersRoot = "/managed-ledgers";
        PulsarClusterMetadataTeardown.getChildren(zooKeeper, "/managed-ledgers").forEach(tenant -> {
            String tenantRoot = "/managed-ledgers/" + tenant;
            PulsarClusterMetadataTeardown.getChildren(zooKeeper, tenantRoot).forEach(namespace -> {
                String namespaceRoot = String.join((CharSequence)"/", tenantRoot, namespace, "persistent");
                PulsarClusterMetadataTeardown.getChildren(zooKeeper, namespaceRoot).forEach(topic -> {
                    TopicName topicName = TopicName.get(String.join((CharSequence)"/", tenant, namespace, topic));
                    try {
                        managedLedgerFactory.delete(topicName.getPersistenceNamingEncoding());
                    }
                    catch (InterruptedException | ManagedLedgerException e) {
                        log.error("Failed to delete ledgers of {}: {}", (Object)topicName, (Object)e);
                        throw new RuntimeException(e);
                    }
                });
            });
        });
    }

    private static void deleteSchemaLedgers(ZooKeeper zooKeeper, BookKeeper bookKeeper) {
        String schemaLedgersRoot = "/schemas";
        PulsarClusterMetadataTeardown.getChildren(zooKeeper, "/schemas").forEach(tenant -> {
            String tenantRoot = "/schemas/" + tenant;
            PulsarClusterMetadataTeardown.getChildren(zooKeeper, tenantRoot).forEach(namespace -> {
                String namespaceRoot = tenantRoot + "/" + namespace;
                PulsarClusterMetadataTeardown.getChildren(zooKeeper, namespaceRoot).forEach(topic -> {
                    String topicRoot = namespaceRoot + "/" + topic;
                    try {
                        SchemaStorageFormat.SchemaLocator.parseFrom(PulsarClusterMetadataTeardown.getData(zooKeeper, topicRoot)).getIndexList().stream().map(indexEntry -> indexEntry.getPosition().getLedgerId()).forEach(ledgerId -> PulsarClusterMetadataTeardown.deleteLedger(bookKeeper, ledgerId));
                    }
                    catch (InvalidProtocolBufferException e) {
                        log.warn("Invalid data format from {}: {}", (Object)topicRoot, (Object)e);
                    }
                });
            });
        });
    }

    private static class Arguments {
        @Parameter(names={"-zk", "--zookeeper"}, description="Local ZooKeeper quorum connection string", required=true)
        private String zookeeper;
        @Parameter(names={"--zookeeper-session-timeout-ms"}, description="Local zookeeper session timeout ms")
        private int zkSessionTimeoutMillis = 30000;
        @Parameter(names={"-c", "-cluster"}, description="Cluster name")
        private String cluster;
        @Parameter(names={"-cs", "--configuration-store"}, description="Configuration Store connection string")
        private String configurationStore;
        @Parameter(names={"--bookkeeper-metadata-service-uri"}, description="Metadata service uri of BookKeeper")
        private String bkMetadataServiceUri;
        @Parameter(names={"-h", "--help"}, description="Show this help message")
        private boolean help = false;

        private Arguments() {
        }
    }
}

