/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar;

import java.util.List;
import org.apache.pulsar.PulsarClusterMetadataSetup;
import org.apache.pulsar.shade.com.beust.jcommander.JCommander;
import org.apache.pulsar.shade.com.beust.jcommander.Parameter;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.shade.org.apache.zookeeper.ZooKeeper;

public class PulsarInitialNamespaceSetup {
    public static void main(String[] args) throws Exception {
        Arguments arguments = new Arguments();
        JCommander jcommander = new JCommander();
        try {
            jcommander.addObject(arguments);
            jcommander.parse(args);
            if (arguments.help) {
                jcommander.usage();
                return;
            }
        }
        catch (Exception e) {
            jcommander.usage();
            throw e;
        }
        if (arguments.configurationStore == null) {
            System.err.println("Configuration store address argument is required (--configuration-store)");
            jcommander.usage();
            System.exit(1);
        }
        ZooKeeper configStoreZk = PulsarClusterMetadataSetup.initZk(arguments.configurationStore, arguments.zkSessionTimeoutMillis);
        for (String namespace : arguments.namespaces) {
            NamespaceName namespaceName = null;
            try {
                namespaceName = NamespaceName.get(namespace);
            }
            catch (Exception e) {
                System.out.println("Invalid namespace name.");
                System.exit(1);
            }
            PulsarClusterMetadataSetup.createTenantIfAbsent(configStoreZk, namespaceName.getTenant(), arguments.cluster);
            PulsarClusterMetadataSetup.createNamespaceIfAbsent(configStoreZk, namespaceName, arguments.cluster);
        }
        System.out.println("Initial namespace setup success");
    }

    private static class Arguments {
        @Parameter(names={"-c", "--cluster"}, description="Cluster name", required=true)
        private String cluster;
        @Parameter(names={"-cs", "--configuration-store"}, description="Configuration Store connection string", required=true)
        private String configurationStore;
        @Parameter(names={"--zookeeper-session-timeout-ms"}, description="Local zookeeper session timeout ms")
        private int zkSessionTimeoutMillis = 30000;
        @Parameter(description="tenant/namespace", required=true)
        private List<String> namespaces;
        @Parameter(names={"-h", "--help"}, description="Show this help message")
        private boolean help = false;

        private Arguments() {
        }
    }
}

