/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker;

import java.util.Map;
import java.util.Set;
import org.apache.pulsar.broker.BundleData;
import org.apache.pulsar.broker.TimeAverageMessageData;
import org.apache.pulsar.shade.com.google.common.base.MoreObjects;
import org.apache.pulsar.shade.org.apache.pulsar.policies.data.loadbalancer.JSONWritable;
import org.apache.pulsar.shade.org.apache.pulsar.policies.data.loadbalancer.NamespaceBundleStats;

public class TimeAverageBrokerData
extends JSONWritable {
    private double shortTermMsgThroughputIn;
    private double shortTermMsgThroughputOut;
    private double shortTermMsgRateIn;
    private double shortTermMsgRateOut;
    private double longTermMsgThroughputIn;
    private double longTermMsgThroughputOut;
    private double longTermMsgRateIn;
    private double longTermMsgRateOut;

    public TimeAverageBrokerData() {
    }

    public TimeAverageBrokerData(Set<String> bundles, Map<String, BundleData> data, NamespaceBundleStats defaultStats) {
        this.reset(bundles, data, defaultStats);
    }

    public void reset(Set<String> bundles, Map<String, BundleData> data, NamespaceBundleStats defaultStats) {
        this.shortTermMsgThroughputIn = 0.0;
        this.shortTermMsgThroughputOut = 0.0;
        this.shortTermMsgRateIn = 0.0;
        this.shortTermMsgRateOut = 0.0;
        this.longTermMsgThroughputIn = 0.0;
        this.longTermMsgThroughputOut = 0.0;
        this.longTermMsgRateIn = 0.0;
        this.longTermMsgRateOut = 0.0;
        for (String bundle : bundles) {
            BundleData bundleData = data.get(bundle);
            if (bundleData == null) {
                this.shortTermMsgThroughputIn += defaultStats.msgThroughputIn;
                this.shortTermMsgThroughputOut += defaultStats.msgThroughputOut;
                this.shortTermMsgRateIn += defaultStats.msgRateIn;
                this.shortTermMsgRateOut += defaultStats.msgRateOut;
                this.longTermMsgThroughputIn += defaultStats.msgThroughputIn;
                this.longTermMsgThroughputOut += defaultStats.msgThroughputOut;
                this.longTermMsgRateIn += defaultStats.msgRateIn;
                this.longTermMsgRateOut += defaultStats.msgRateOut;
                continue;
            }
            TimeAverageMessageData shortTermData = bundleData.getShortTermData();
            TimeAverageMessageData longTermData = bundleData.getLongTermData();
            this.shortTermMsgThroughputIn += shortTermData.getMsgThroughputIn();
            this.shortTermMsgThroughputOut += shortTermData.getMsgThroughputOut();
            this.shortTermMsgRateIn += shortTermData.getMsgRateIn();
            this.shortTermMsgRateOut += shortTermData.getMsgRateOut();
            this.longTermMsgThroughputIn += longTermData.getMsgThroughputIn();
            this.longTermMsgThroughputOut += longTermData.getMsgThroughputOut();
            this.longTermMsgRateIn += longTermData.getMsgRateIn();
            this.longTermMsgRateOut += longTermData.getMsgRateOut();
        }
    }

    public double getShortTermMsgThroughputIn() {
        return this.shortTermMsgThroughputIn;
    }

    public void setShortTermMsgThroughputIn(double shortTermMsgThroughputIn) {
        this.shortTermMsgThroughputIn = shortTermMsgThroughputIn;
    }

    public double getShortTermMsgThroughputOut() {
        return this.shortTermMsgThroughputOut;
    }

    public void setShortTermMsgThroughputOut(double shortTermMsgThroughputOut) {
        this.shortTermMsgThroughputOut = shortTermMsgThroughputOut;
    }

    public double getShortTermMsgRateIn() {
        return this.shortTermMsgRateIn;
    }

    public void setShortTermMsgRateIn(double shortTermMsgRateIn) {
        this.shortTermMsgRateIn = shortTermMsgRateIn;
    }

    public double getShortTermMsgRateOut() {
        return this.shortTermMsgRateOut;
    }

    public void setShortTermMsgRateOut(double shortTermMsgRateOut) {
        this.shortTermMsgRateOut = shortTermMsgRateOut;
    }

    public double getLongTermMsgThroughputIn() {
        return this.longTermMsgThroughputIn;
    }

    public void setLongTermMsgThroughputIn(double longTermMsgThroughputIn) {
        this.longTermMsgThroughputIn = longTermMsgThroughputIn;
    }

    public double getLongTermMsgThroughputOut() {
        return this.longTermMsgThroughputOut;
    }

    public void setLongTermMsgThroughputOut(double longTermMsgThroughputOut) {
        this.longTermMsgThroughputOut = longTermMsgThroughputOut;
    }

    public double getLongTermMsgRateIn() {
        return this.longTermMsgRateIn;
    }

    public void setLongTermMsgRateIn(double longTermMsgRateIn) {
        this.longTermMsgRateIn = longTermMsgRateIn;
    }

    public double getLongTermMsgRateOut() {
        return this.longTermMsgRateOut;
    }

    public void setLongTermMsgRateOut(double longTermMsgRateOut) {
        this.longTermMsgRateOut = longTermMsgRateOut;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("shortTermMsgThroughputIn", this.shortTermMsgThroughputIn).add("shortTermMsgThroughputOut", this.shortTermMsgThroughputOut).add("shortTermMsgRateIn", this.shortTermMsgRateIn).add("shortTermMsgRateOut", this.shortTermMsgRateOut).add("longTermMsgThroughputIn", this.longTermMsgThroughputIn).add("longTermMsgThroughputOut", this.longTermMsgThroughputOut).add("longTermMsgRateIn", this.longTermMsgRateIn).add("longTermMsgRateOut", this.longTermMsgRateOut).toString();
    }
}

