/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v2;

import org.apache.pulsar.broker.admin.impl.ResourceQuotasBase;
import org.apache.pulsar.shade.io.swagger.annotations.Api;
import org.apache.pulsar.shade.io.swagger.annotations.ApiOperation;
import org.apache.pulsar.shade.io.swagger.annotations.ApiParam;
import org.apache.pulsar.shade.io.swagger.annotations.ApiResponse;
import org.apache.pulsar.shade.io.swagger.annotations.ApiResponses;
import org.apache.pulsar.shade.javax.ws.rs.Consumes;
import org.apache.pulsar.shade.javax.ws.rs.DELETE;
import org.apache.pulsar.shade.javax.ws.rs.GET;
import org.apache.pulsar.shade.javax.ws.rs.POST;
import org.apache.pulsar.shade.javax.ws.rs.Path;
import org.apache.pulsar.shade.javax.ws.rs.PathParam;
import org.apache.pulsar.shade.javax.ws.rs.Produces;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.ResourceQuota;

@Path(value="/resource-quotas")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/resource-quotas", description="Quota admin APIs", tags={"resource-quotas"})
public class ResourceQuotas
extends ResourceQuotasBase {
    @Override
    @GET
    @ApiOperation(value="Get the default quota", response=String.class, responseContainer="Set")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public ResourceQuota getDefaultResourceQuota() throws Exception {
        return super.getDefaultResourceQuota();
    }

    @Override
    @POST
    @ApiOperation(value="Set the default quota", response=String.class, responseContainer="Set")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public void setDefaultResourceQuota(@ApiParam(value="Default resource quota") ResourceQuota quota) throws Exception {
        super.setDefaultResourceQuota(quota);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{bundle}")
    @ApiOperation(value="Get resource quota of a namespace bundle.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public ResourceQuota getNamespaceBundleResourceQuota(@ApiParam(value="Tenant name") @PathParam(value="tenant") String tenant, @ApiParam(value="Namespace name within the specified tenant") @PathParam(value="namespace") String namespace, @ApiParam(value="Namespace bundle range") @PathParam(value="bundle") String bundleRange) {
        this.validateNamespaceName(tenant, namespace);
        return this.internalGetNamespaceBundleResourceQuota(bundleRange);
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{bundle}")
    @ApiOperation(value="Set resource quota on a namespace.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=409, message="Concurrent modification")})
    public void setNamespaceBundleResourceQuota(@ApiParam(value="Tenant name") @PathParam(value="tenant") String tenant, @ApiParam(value="Namespace name within the specified tenant") @PathParam(value="namespace") String namespace, @ApiParam(value="Namespace bundle range") @PathParam(value="bundle") String bundleRange, @ApiParam(value="Resource quota for the specified namespace") ResourceQuota quota) {
        this.validateNamespaceName(tenant, namespace);
        this.internalSetNamespaceBundleResourceQuota(bundleRange, quota);
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{bundle}")
    @ApiOperation(value="Remove resource quota for a namespace.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=409, message="Concurrent modification")})
    public void removeNamespaceBundleResourceQuota(@ApiParam(value="Tenant name") @PathParam(value="tenant") String tenant, @ApiParam(value="Namespace name within the specified tenant") @PathParam(value="namespace") String namespace, @ApiParam(value="Namespace bundle range") @PathParam(value="bundle") String bundleRange) {
        this.validateNamespaceName(tenant, namespace);
        this.internalRemoveNamespaceBundleResourceQuota(bundleRange);
    }
}

