/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.intercept;

import java.io.IOException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.intercept.BrokerInterceptor;
import org.apache.pulsar.broker.service.ServerCnx;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.shade.javax.servlet.ServletException;
import org.apache.pulsar.shade.javax.servlet.ServletRequest;
import org.apache.pulsar.shade.javax.servlet.ServletResponse;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.Entry;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.shade.org.apache.pulsar.common.intercept.InterceptException;
import org.apache.pulsar.shade.org.apache.pulsar.common.nar.NarClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerInterceptorWithClassLoader
implements BrokerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(BrokerInterceptorWithClassLoader.class);
    private final BrokerInterceptor interceptor;
    private final NarClassLoader classLoader;

    @Override
    public void beforeSendMessage(Subscription subscription, Entry entry, long[] ackSet, PulsarApi.MessageMetadata msgMetadata) {
        this.interceptor.beforeSendMessage(subscription, entry, ackSet, msgMetadata);
    }

    @Override
    public void onPulsarCommand(PulsarApi.BaseCommand command, ServerCnx cnx) throws InterceptException {
        this.interceptor.onPulsarCommand(command, cnx);
    }

    @Override
    public void onConnectionClosed(ServerCnx cnx) {
        this.interceptor.onConnectionClosed(cnx);
    }

    @Override
    public void onWebserviceRequest(ServletRequest request) throws IOException, ServletException, InterceptException {
        this.interceptor.onWebserviceRequest(request);
    }

    @Override
    public void onWebserviceResponse(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        this.interceptor.onWebserviceResponse(request, response);
    }

    @Override
    public void initialize(PulsarService pulsarService) throws Exception {
        this.interceptor.initialize(pulsarService);
    }

    @Override
    public void close() {
        this.interceptor.close();
        try {
            this.classLoader.close();
        }
        catch (IOException e) {
            log.warn("Failed to close the broker interceptor class loader", (Throwable)e);
        }
    }

    public BrokerInterceptor getInterceptor() {
        return this.interceptor;
    }

    public NarClassLoader getClassLoader() {
        return this.classLoader;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BrokerInterceptorWithClassLoader)) {
            return false;
        }
        BrokerInterceptorWithClassLoader other = (BrokerInterceptorWithClassLoader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BrokerInterceptor this$interceptor = this.getInterceptor();
        BrokerInterceptor other$interceptor = other.getInterceptor();
        if (this$interceptor == null ? other$interceptor != null : !this$interceptor.equals(other$interceptor)) {
            return false;
        }
        NarClassLoader this$classLoader = this.getClassLoader();
        NarClassLoader other$classLoader = other.getClassLoader();
        return !(this$classLoader == null ? other$classLoader != null : !this$classLoader.equals(other$classLoader));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BrokerInterceptorWithClassLoader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BrokerInterceptor $interceptor = this.getInterceptor();
        result = result * 59 + ($interceptor == null ? 43 : $interceptor.hashCode());
        NarClassLoader $classLoader = this.getClassLoader();
        result = result * 59 + ($classLoader == null ? 43 : $classLoader.hashCode());
        return result;
    }

    public String toString() {
        return "BrokerInterceptorWithClassLoader(interceptor=" + this.getInterceptor() + ", classLoader=" + this.getClassLoader() + ")";
    }

    public BrokerInterceptorWithClassLoader(BrokerInterceptor interceptor, NarClassLoader classLoader) {
        this.interceptor = interceptor;
        this.classLoader = classLoader;
    }
}

