/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.metrics;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.com.google.common.collect.Maps;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedLedgerFactoryMXBean;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.ManagedLedgerMBeanImpl;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.TopicStats;
import org.apache.pulsar.shade.org.apache.pulsar.common.stats.Metrics;

abstract class AbstractMetrics {
    protected static final String METRICS_VERSION_SUFFIX = "v2";
    protected static final Pattern V2_LEDGER_NAME_PATTERN;
    protected static final double[] ENTRY_LATENCY_BUCKETS_MS;
    protected static final double[] ENTRY_SIZE_BUCKETS_BYTES;
    protected final PulsarService pulsar;

    abstract List<Metrics> generate();

    AbstractMetrics(PulsarService pulsar) {
        this.pulsar = pulsar;
    }

    protected Metrics createMetrics() {
        return this.createMetrics(new HashMap<String, String>());
    }

    protected Metrics createMetrics(Map<String, String> dimensionMap) {
        return Metrics.create(dimensionMap);
    }

    protected ManagedLedgerFactoryMXBean getManagedLedgerCacheStats() {
        return ((ManagedLedgerFactoryImpl)this.pulsar.getManagedLedgerFactory()).getCacheStats();
    }

    protected Map<String, ManagedLedgerImpl> getManagedLedgers() {
        return ((ManagedLedgerFactoryImpl)this.pulsar.getManagedLedgerFactory()).getManagedLedgers();
    }

    protected String getLocalClusterName() {
        return this.pulsar.getConfiguration().getClusterName();
    }

    protected double average(List<Double> values) {
        double average = 0.0;
        if (values.size() > 0) {
            double sum = 0.0;
            for (Double value : values) {
                sum += value.doubleValue();
            }
            average = sum / (double)values.size();
        }
        return average;
    }

    protected double sum(List<Double> values) {
        double sum = 0.0;
        if (values.size() > 0) {
            for (Double value : values) {
                sum += value.doubleValue();
            }
        }
        return sum;
    }

    protected String parseNamespaceFromLedgerName(String ledgerName) {
        Matcher m = V2_LEDGER_NAME_PATTERN.matcher(ledgerName);
        if (m.matches()) {
            return m.group(1);
        }
        throw new RuntimeException("Failed to parse the namespace from ledger name : " + ledgerName);
    }

    protected Metrics createMetricsByDimension(String namespace) {
        HashMap<String, String> dimensionMap = Maps.newHashMap();
        dimensionMap.put("namespace", namespace);
        return this.createMetrics(dimensionMap);
    }

    protected Metrics createMetricsByDimension(String namespace, String fromClusterName, String toClusterName) {
        HashMap<String, String> dimensionMap = Maps.newHashMap();
        dimensionMap.put("namespace", namespace);
        dimensionMap.put("from_cluster", fromClusterName);
        dimensionMap.put("to_cluster", toClusterName);
        return this.createMetrics(dimensionMap);
    }

    protected void populateBucketEntries(Map<String, Double> map, String mkey, double[] boundaries, long[] bucketValues, int period) {
        if (bucketValues != null && bucketValues.length != boundaries.length + 1) {
            throw new RuntimeException("Bucket boundary and value array length mismatch");
        }
        for (int i = 0; i < boundaries.length + 1; ++i) {
            String bucketKey = i == 0 && boundaries.length > 0 ? String.format("%s_0.0_%1.1f", mkey, boundaries[i]) : (i < boundaries.length ? String.format("%s_%1.1f_%1.1f", mkey, boundaries[i - 1], boundaries[i]) : String.format("%s_OVERFLOW", mkey));
            double value = bucketValues == null ? 0.0 : (double)bucketValues[i] / (double)(period > 0 ? period : 1);
            Double val = map.getOrDefault(bucketKey, 0.0);
            map.put(bucketKey, val + value);
        }
    }

    protected void populateAggregationMap(Map<String, List<Double>> map, String mkey, double value) {
        if (!map.containsKey(mkey)) {
            map.put(mkey, Lists.newArrayList(value));
        } else {
            map.get(mkey).add(value);
        }
    }

    protected void populateAggregationMapWithSum(Map<String, Double> map, String mkey, double value) {
        Double val = map.getOrDefault(mkey, 0.0);
        map.put(mkey, val + value);
    }

    protected void populateMaxMap(Map<String, Long> map, String mkey, long value) {
        Long existingValue = map.get(mkey);
        if (existingValue == null || value > existingValue) {
            map.put(mkey, value);
        }
    }

    protected void populateDimensionMap(Map<Metrics, List<ManagedLedgerImpl>> ledgersByDimensionMap, Metrics metrics, ManagedLedgerImpl ledger) {
        if (!ledgersByDimensionMap.containsKey(metrics)) {
            ledgersByDimensionMap.put(metrics, Lists.newArrayList(ledger));
        } else {
            ledgersByDimensionMap.get(metrics).add(ledger);
        }
    }

    protected void populateDimensionMap(Map<Metrics, List<TopicStats>> topicsStatsByDimensionMap, Metrics metrics, TopicStats destStats) {
        if (!topicsStatsByDimensionMap.containsKey(metrics)) {
            topicsStatsByDimensionMap.put(metrics, Lists.newArrayList(destStats));
        } else {
            topicsStatsByDimensionMap.get(metrics).add(destStats);
        }
    }

    static {
        int i;
        V2_LEDGER_NAME_PATTERN = Pattern.compile("^(([^/]+)/([^/]+)/([^/]+))/(.*)$");
        ENTRY_LATENCY_BUCKETS_MS = new double[ManagedLedgerMBeanImpl.ENTRY_LATENCY_BUCKETS_USEC.length];
        for (i = 0; i < ManagedLedgerMBeanImpl.ENTRY_LATENCY_BUCKETS_USEC.length; ++i) {
            AbstractMetrics.ENTRY_LATENCY_BUCKETS_MS[i] = (double)ManagedLedgerMBeanImpl.ENTRY_LATENCY_BUCKETS_USEC[i] / 1000.0;
        }
        ENTRY_SIZE_BUCKETS_BYTES = new double[ManagedLedgerMBeanImpl.ENTRY_SIZE_BUCKETS_BYTES.length];
        for (i = 0; i < ManagedLedgerMBeanImpl.ENTRY_SIZE_BUCKETS_BYTES.length; ++i) {
            AbstractMetrics.ENTRY_SIZE_BUCKETS_BYTES[i] = ManagedLedgerMBeanImpl.ENTRY_SIZE_BUCKETS_BYTES[i];
        }
    }
}

