/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.buffer;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.transaction.buffer.TransactionBuffer;
import org.apache.pulsar.shade.com.google.common.annotations.Beta;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;

@Beta
public interface TransactionBufferProvider {
    public static TransactionBufferProvider newProvider(String providerClassName) throws IOException {
        try {
            Class<?> providerClass = Class.forName(providerClassName);
            Object obj = providerClass.newInstance();
            Preconditions.checkArgument(obj instanceof TransactionBufferProvider, "The factory has to be an instance of " + TransactionBufferProvider.class.getName());
            return (TransactionBufferProvider)obj;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public CompletableFuture<TransactionBuffer> newTransactionBuffer();

    public CompletableFuture<TransactionBuffer> newTransactionBuffer(Topic var1);
}

