/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.io.File;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.Source;
import org.apache.pulsar.client.admin.Sources;
import org.apache.pulsar.client.admin.internal.ComponentResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.shade.com.google.gson.Gson;
import org.apache.pulsar.shade.javax.ws.rs.client.Entity;
import org.apache.pulsar.shade.javax.ws.rs.client.InvocationCallback;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;
import org.apache.pulsar.shade.javax.ws.rs.core.GenericType;
import org.apache.pulsar.shade.javax.ws.rs.core.MediaType;
import org.apache.pulsar.shade.javax.ws.rs.core.Response;
import org.apache.pulsar.shade.org.apache.pulsar.common.functions.UpdateOptions;
import org.apache.pulsar.shade.org.apache.pulsar.common.io.ConnectorDefinition;
import org.apache.pulsar.shade.org.apache.pulsar.common.io.SourceConfig;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.SourceStatus;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.shade.org.asynchttpclient.AsyncHttpClient;
import org.apache.pulsar.shade.org.asynchttpclient.Dsl;
import org.apache.pulsar.shade.org.asynchttpclient.RequestBuilder;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.multipart.FilePart;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.multipart.StringPart;
import org.apache.pulsar.shade.org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.apache.pulsar.shade.org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourcesImpl
extends ComponentResource
implements Sources,
Source {
    private static final Logger log = LoggerFactory.getLogger(SourcesImpl.class);
    private final WebTarget source;
    private final AsyncHttpClient asyncHttpClient;

    public SourcesImpl(WebTarget web, Authentication auth, AsyncHttpClient asyncHttpClient, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.source = web.path("/admin/v3/source");
        this.asyncHttpClient = asyncHttpClient;
    }

    @Override
    public List<String> listSources(String tenant, String namespace) throws PulsarAdminException {
        try {
            return this.listSourcesAsync(tenant, namespace).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<List<String>> listSourcesAsync(String tenant, String namespace) {
        WebTarget path = this.source.path(tenant).path(namespace);
        final CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            @Override
            public void completed(Response response) {
                if (!response.getStatusInfo().equals(Response.Status.OK)) {
                    future.completeExceptionally(SourcesImpl.this.getApiException(response));
                } else {
                    future.complete(response.readEntity(new GenericType<List<String>>(){}));
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(SourcesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public SourceConfig getSource(String tenant, String namespace, String sourceName) throws PulsarAdminException {
        try {
            return this.getSourceAsync(tenant, namespace, sourceName).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<SourceConfig> getSourceAsync(String tenant, String namespace, String sourceName) {
        WebTarget path = this.source.path(tenant).path(namespace).path(sourceName);
        final CompletableFuture<SourceConfig> future = new CompletableFuture<SourceConfig>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            @Override
            public void completed(Response response) {
                if (!response.getStatusInfo().equals(Response.Status.OK)) {
                    future.completeExceptionally(SourcesImpl.this.getApiException(response));
                } else {
                    future.complete(response.readEntity(SourceConfig.class));
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(SourcesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public SourceStatus getSourceStatus(String tenant, String namespace, String sourceName) throws PulsarAdminException {
        try {
            return this.getSourceStatusAsync(tenant, namespace, sourceName).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<SourceStatus> getSourceStatusAsync(String tenant, String namespace, String sourceName) {
        WebTarget path = this.source.path(tenant).path(namespace).path(sourceName).path("status");
        final CompletableFuture<SourceStatus> future = new CompletableFuture<SourceStatus>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            @Override
            public void completed(Response response) {
                if (!response.getStatusInfo().equals(Response.Status.OK)) {
                    future.completeExceptionally(SourcesImpl.this.getApiException(response));
                } else {
                    future.complete(response.readEntity(SourceStatus.class));
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(SourcesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public SourceStatus.SourceInstanceStatus.SourceInstanceStatusData getSourceStatus(String tenant, String namespace, String sourceName, int id) throws PulsarAdminException {
        try {
            return this.getSourceStatusAsync(tenant, namespace, sourceName, id).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<SourceStatus.SourceInstanceStatus.SourceInstanceStatusData> getSourceStatusAsync(String tenant, String namespace, String sourceName, int id) {
        WebTarget path = this.source.path(tenant).path(namespace).path(sourceName).path(Integer.toString(id)).path("status");
        final CompletableFuture<SourceStatus.SourceInstanceStatus.SourceInstanceStatusData> future = new CompletableFuture<SourceStatus.SourceInstanceStatus.SourceInstanceStatusData>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            @Override
            public void completed(Response response) {
                if (!response.getStatusInfo().equals(Response.Status.OK)) {
                    future.completeExceptionally(SourcesImpl.this.getApiException(response));
                } else {
                    future.complete(response.readEntity(SourceStatus.SourceInstanceStatus.SourceInstanceStatusData.class));
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(SourcesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void createSource(SourceConfig sourceConfig, String fileName) throws PulsarAdminException {
        try {
            this.createSourceAsync(sourceConfig, fileName).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<Void> createSourceAsync(SourceConfig sourceConfig, String fileName) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            RequestBuilder builder = (RequestBuilder)Dsl.post(this.source.path(sourceConfig.getTenant()).path(sourceConfig.getNamespace()).path(sourceConfig.getName()).getUri().toASCIIString()).addBodyPart(new StringPart("sourceConfig", ObjectMapperFactory.getThreadLocal().writeValueAsString(sourceConfig), "application/json"));
            if (fileName != null && !fileName.startsWith("builtin://")) {
                builder.addBodyPart(new FilePart("data", new File(fileName), "application/octet-stream"));
            }
            ((CompletableFuture)this.asyncHttpClient.executeRequest(this.addAuthHeaders(this.source, builder).build()).toCompletableFuture().thenAccept(response -> {
                if (response.getStatusCode() < 200 || response.getStatusCode() >= 300) {
                    future.completeExceptionally(this.getApiException(Response.status(response.getStatusCode()).entity(response.getResponseBody()).build()));
                } else {
                    future.complete(null);
                }
            })).exceptionally(throwable -> {
                future.completeExceptionally(this.getApiException((Throwable)throwable));
                return null;
            });
        }
        catch (Exception e) {
            future.completeExceptionally(this.getApiException(e));
        }
        return future;
    }

    @Override
    public void createSourceWithUrl(SourceConfig sourceConfig, String pkgUrl) throws PulsarAdminException {
        try {
            this.createSourceWithUrlAsync(sourceConfig, pkgUrl).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<Void> createSourceWithUrlAsync(SourceConfig sourceConfig, String pkgUrl) {
        FormDataMultiPart mp = new FormDataMultiPart();
        mp.bodyPart(new FormDataBodyPart("url", (Object)pkgUrl, MediaType.TEXT_PLAIN_TYPE));
        mp.bodyPart(new FormDataBodyPart("sourceConfig", (Object)new Gson().toJson(sourceConfig), MediaType.APPLICATION_JSON_TYPE));
        WebTarget path = this.source.path(sourceConfig.getTenant()).path(sourceConfig.getNamespace()).path(sourceConfig.getName());
        return this.asyncPostRequest(path, Entity.entity(mp, "multipart/form-data"));
    }

    @Override
    public void deleteSource(String cluster, String namespace, String function) throws PulsarAdminException {
        try {
            this.deleteSourceAsync(cluster, namespace, function).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<Void> deleteSourceAsync(String tenant, String namespace, String function) {
        WebTarget path = this.source.path(tenant).path(namespace).path(function);
        return this.asyncDeleteRequest(path);
    }

    @Override
    public void updateSource(SourceConfig sourceConfig, String fileName, UpdateOptions updateOptions) throws PulsarAdminException {
        try {
            this.updateSourceAsync(sourceConfig, fileName, updateOptions).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<Void> updateSourceAsync(SourceConfig sourceConfig, String fileName, UpdateOptions updateOptions) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            RequestBuilder builder = (RequestBuilder)Dsl.put(this.source.path(sourceConfig.getTenant()).path(sourceConfig.getNamespace()).path(sourceConfig.getName()).getUri().toASCIIString()).addBodyPart(new StringPart("sourceConfig", ObjectMapperFactory.getThreadLocal().writeValueAsString(sourceConfig), "application/json"));
            if (updateOptions != null) {
                builder.addBodyPart(new StringPart("updateOptions", ObjectMapperFactory.getThreadLocal().writeValueAsString(updateOptions), "application/json"));
            }
            if (fileName != null && !fileName.startsWith("builtin://")) {
                builder.addBodyPart(new FilePart("data", new File(fileName), "application/octet-stream"));
            }
            ((CompletableFuture)this.asyncHttpClient.executeRequest(this.addAuthHeaders(this.source, builder).build()).toCompletableFuture().thenAccept(response -> {
                if (response.getStatusCode() < 200 || response.getStatusCode() >= 300) {
                    future.completeExceptionally(this.getApiException(Response.status(response.getStatusCode()).entity(response.getResponseBody()).build()));
                } else {
                    future.complete(null);
                }
            })).exceptionally(throwable -> {
                future.completeExceptionally(this.getApiException((Throwable)throwable));
                return null;
            });
        }
        catch (Exception e) {
            future.completeExceptionally(this.getApiException(e));
        }
        return future;
    }

    @Override
    public void updateSource(SourceConfig sourceConfig, String fileName) throws PulsarAdminException {
        this.updateSource(sourceConfig, fileName, null);
    }

    @Override
    public CompletableFuture<Void> updateSourceAsync(SourceConfig sourceConfig, String fileName) {
        return this.updateSourceAsync(sourceConfig, fileName, null);
    }

    @Override
    public void updateSourceWithUrl(SourceConfig sourceConfig, String pkgUrl, UpdateOptions updateOptions) throws PulsarAdminException {
        try {
            this.updateSourceWithUrlAsync(sourceConfig, pkgUrl, updateOptions).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<Void> updateSourceWithUrlAsync(SourceConfig sourceConfig, String pkgUrl, UpdateOptions updateOptions) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            FormDataMultiPart mp = new FormDataMultiPart();
            mp.bodyPart(new FormDataBodyPart("url", (Object)pkgUrl, MediaType.TEXT_PLAIN_TYPE));
            mp.bodyPart(new FormDataBodyPart("sourceConfig", (Object)new Gson().toJson(sourceConfig), MediaType.APPLICATION_JSON_TYPE));
            if (updateOptions != null) {
                mp.bodyPart(new FormDataBodyPart("updateOptions", (Object)ObjectMapperFactory.getThreadLocal().writeValueAsString(updateOptions), MediaType.APPLICATION_JSON_TYPE));
            }
            WebTarget path = this.source.path(sourceConfig.getTenant()).path(sourceConfig.getNamespace()).path(sourceConfig.getName());
            return this.asyncPutRequest(path, Entity.entity(mp, "multipart/form-data"));
        }
        catch (Exception e) {
            future.completeExceptionally(this.getApiException(e));
            return future;
        }
    }

    @Override
    public void updateSourceWithUrl(SourceConfig sourceConfig, String pkgUrl) throws PulsarAdminException {
        this.updateSourceWithUrl(sourceConfig, pkgUrl, null);
    }

    @Override
    public CompletableFuture<Void> updateSourceWithUrlAsync(SourceConfig sourceConfig, String pkgUrl) {
        return this.updateSourceWithUrlAsync(sourceConfig, pkgUrl, null);
    }

    @Override
    public void restartSource(String tenant, String namespace, String functionName, int instanceId) throws PulsarAdminException {
        try {
            this.restartSourceAsync(tenant, namespace, functionName, instanceId).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<Void> restartSourceAsync(String tenant, String namespace, String functionName, int instanceId) {
        WebTarget path = this.source.path(tenant).path(namespace).path(functionName).path(Integer.toString(instanceId)).path("restart");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public void restartSource(String tenant, String namespace, String functionName) throws PulsarAdminException {
        try {
            this.restartSourceAsync(tenant, namespace, functionName).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<Void> restartSourceAsync(String tenant, String namespace, String functionName) {
        WebTarget path = this.source.path(tenant).path(namespace).path(functionName).path("restart");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public void stopSource(String tenant, String namespace, String sourceName, int instanceId) throws PulsarAdminException {
        try {
            this.stopSourceAsync(tenant, namespace, sourceName, instanceId).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<Void> stopSourceAsync(String tenant, String namespace, String sourceName, int instanceId) {
        WebTarget path = this.source.path(tenant).path(namespace).path(sourceName).path(Integer.toString(instanceId)).path("stop");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public void stopSource(String tenant, String namespace, String sourceName) throws PulsarAdminException {
        try {
            this.stopSourceAsync(tenant, namespace, sourceName).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<Void> stopSourceAsync(String tenant, String namespace, String sourceName) {
        WebTarget path = this.source.path(tenant).path(namespace).path(sourceName).path("stop");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public void startSource(String tenant, String namespace, String sourceName, int instanceId) throws PulsarAdminException {
        try {
            this.startSourceAsync(tenant, namespace, sourceName, instanceId).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<Void> startSourceAsync(String tenant, String namespace, String sourceName, int instanceId) {
        WebTarget path = this.source.path(tenant).path(namespace).path(sourceName).path(Integer.toString(instanceId)).path("start");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public void startSource(String tenant, String namespace, String sourceName) throws PulsarAdminException {
        try {
            this.startSourceAsync(tenant, namespace, sourceName).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<Void> startSourceAsync(String tenant, String namespace, String sourceName) {
        WebTarget path = this.source.path(tenant).path(namespace).path(sourceName).path("start");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public List<ConnectorDefinition> getBuiltInSources() throws PulsarAdminException {
        try {
            return this.getBuiltInSourcesAsync().get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<List<ConnectorDefinition>> getBuiltInSourcesAsync() {
        WebTarget path = this.source.path("builtinsources");
        final CompletableFuture<List<ConnectorDefinition>> future = new CompletableFuture<List<ConnectorDefinition>>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            @Override
            public void completed(Response response) {
                if (!response.getStatusInfo().equals(Response.Status.OK)) {
                    future.completeExceptionally(SourcesImpl.this.getApiException(response));
                } else {
                    future.complete(response.readEntity(new GenericType<List<ConnectorDefinition>>(){}));
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(SourcesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void reloadBuiltInSources() throws PulsarAdminException {
        try {
            this.reloadBuiltInSourcesAsync().get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<Void> reloadBuiltInSourcesAsync() {
        WebTarget path = this.source.path("reloadBuiltInSources");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }
}

