/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.util.concurrent.ExecutionException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.api.schema.GenericSchema;
import org.apache.pulsar.client.api.schema.SchemaInfoProvider;
import org.apache.pulsar.client.impl.schema.BooleanSchema;
import org.apache.pulsar.client.impl.schema.ByteSchema;
import org.apache.pulsar.client.impl.schema.BytesSchema;
import org.apache.pulsar.client.impl.schema.DateSchema;
import org.apache.pulsar.client.impl.schema.DoubleSchema;
import org.apache.pulsar.client.impl.schema.FloatSchema;
import org.apache.pulsar.client.impl.schema.InstantSchema;
import org.apache.pulsar.client.impl.schema.IntSchema;
import org.apache.pulsar.client.impl.schema.KeyValueSchema;
import org.apache.pulsar.client.impl.schema.KeyValueSchemaInfo;
import org.apache.pulsar.client.impl.schema.LocalDateSchema;
import org.apache.pulsar.client.impl.schema.LocalDateTimeSchema;
import org.apache.pulsar.client.impl.schema.LocalTimeSchema;
import org.apache.pulsar.client.impl.schema.LongSchema;
import org.apache.pulsar.client.impl.schema.ShortSchema;
import org.apache.pulsar.client.impl.schema.StringSchema;
import org.apache.pulsar.client.impl.schema.TimeSchema;
import org.apache.pulsar.client.impl.schema.TimestampSchema;
import org.apache.pulsar.client.impl.schema.generic.GenericAvroSchema;
import org.apache.pulsar.client.impl.schema.generic.GenericJsonSchema;
import org.apache.pulsar.client.impl.schema.generic.GenericProtobufNativeSchema;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.SchemaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoConsumeSchema
implements Schema<GenericRecord> {
    private static final Logger log = LoggerFactory.getLogger(AutoConsumeSchema.class);
    private Schema<GenericRecord> schema;
    private String topicName;
    private String componentName;
    private SchemaInfoProvider schemaInfoProvider;

    public void setSchema(Schema<GenericRecord> schema) {
        this.schema = schema;
    }

    private void ensureSchemaInitialized() {
        Preconditions.checkState(null != this.schema, "Schema is not initialized before used");
    }

    @Override
    public void validate(byte[] message) {
        this.ensureSchemaInitialized();
        this.schema.validate(message);
    }

    @Override
    public boolean supportSchemaVersioning() {
        return true;
    }

    @Override
    public byte[] encode(GenericRecord message) {
        this.ensureSchemaInitialized();
        return this.schema.encode(message);
    }

    @Override
    public GenericRecord decode(byte[] bytes, byte[] schemaVersion) {
        if (this.schema == null) {
            SchemaInfo schemaInfo = null;
            try {
                schemaInfo = this.schemaInfoProvider.getLatestSchema().get();
            }
            catch (InterruptedException | ExecutionException e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                log.error("Con't get last schema for topic {} use AutoConsumeSchema", (Object)this.topicName);
                throw new SchemaSerializationException(e.getCause());
            }
            this.schema = this.generateSchema(schemaInfo);
            this.schema.setSchemaInfoProvider(this.schemaInfoProvider);
            log.info("Configure {} schema for topic {} : {}", new Object[]{this.componentName, this.topicName, schemaInfo.getSchemaDefinition()});
        }
        this.ensureSchemaInitialized();
        return this.schema.decode(bytes, schemaVersion);
    }

    @Override
    public void setSchemaInfoProvider(SchemaInfoProvider schemaInfoProvider) {
        if (this.schema == null) {
            this.schemaInfoProvider = schemaInfoProvider;
        } else {
            this.schema.setSchemaInfoProvider(schemaInfoProvider);
        }
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        if (this.schema == null) {
            return null;
        }
        return this.schema.getSchemaInfo();
    }

    @Override
    public boolean requireFetchingSchemaInfo() {
        return true;
    }

    @Override
    public void configureSchemaInfo(String topicName, String componentName, SchemaInfo schemaInfo) {
        this.topicName = topicName;
        this.componentName = componentName;
        if (schemaInfo != null) {
            GenericSchema genericSchema = this.generateSchema(schemaInfo);
            this.setSchema(genericSchema);
            log.info("Configure {} schema for topic {} : {}", new Object[]{componentName, topicName, schemaInfo.getSchemaDefinition()});
        }
    }

    @Override
    public Schema<GenericRecord> clone() {
        Schema<GenericRecord> schema = Schema.AUTO_CONSUME();
        if (this.schema != null) {
            schema.configureSchemaInfo(this.topicName, this.componentName, this.schema.getSchemaInfo());
        } else {
            schema.configureSchemaInfo(this.topicName, this.componentName, null);
        }
        if (this.schemaInfoProvider != null) {
            schema.setSchemaInfoProvider(this.schemaInfoProvider);
        }
        return schema;
    }

    private GenericSchema generateSchema(SchemaInfo schemaInfo) {
        boolean useProvidedSchemaAsReaderSchema = false;
        switch (schemaInfo.getType()) {
            case JSON: {
                return GenericJsonSchema.of(schemaInfo, false);
            }
            case AVRO: {
                return GenericAvroSchema.of(schemaInfo, false);
            }
            case PROTOBUF_NATIVE: {
                return GenericProtobufNativeSchema.of(schemaInfo, false);
            }
        }
        throw new IllegalArgumentException("Currently auto consume works for type '" + (Object)((Object)schemaInfo.getType()) + "' is not supported yet");
    }

    public static Schema<?> getSchema(SchemaInfo schemaInfo) {
        switch (schemaInfo.getType()) {
            case INT8: {
                return ByteSchema.of();
            }
            case INT16: {
                return ShortSchema.of();
            }
            case INT32: {
                return IntSchema.of();
            }
            case INT64: {
                return LongSchema.of();
            }
            case STRING: {
                return StringSchema.utf8();
            }
            case FLOAT: {
                return FloatSchema.of();
            }
            case DOUBLE: {
                return DoubleSchema.of();
            }
            case BOOLEAN: {
                return BooleanSchema.of();
            }
            case BYTES: {
                return BytesSchema.of();
            }
            case DATE: {
                return DateSchema.of();
            }
            case TIME: {
                return TimeSchema.of();
            }
            case TIMESTAMP: {
                return TimestampSchema.of();
            }
            case INSTANT: {
                return InstantSchema.of();
            }
            case LOCAL_DATE: {
                return LocalDateSchema.of();
            }
            case LOCAL_TIME: {
                return LocalTimeSchema.of();
            }
            case LOCAL_DATE_TIME: {
                return LocalDateTimeSchema.of();
            }
            case JSON: {
                return GenericJsonSchema.of(schemaInfo);
            }
            case AVRO: {
                return GenericAvroSchema.of(schemaInfo);
            }
            case PROTOBUF_NATIVE: {
                return GenericProtobufNativeSchema.of(schemaInfo);
            }
            case KEY_VALUE: {
                KeyValue<SchemaInfo, SchemaInfo> kvSchemaInfo = KeyValueSchemaInfo.decodeKeyValueSchemaInfo(schemaInfo);
                Schema<?> keySchema = AutoConsumeSchema.getSchema(kvSchemaInfo.getKey());
                Schema<?> valueSchema = AutoConsumeSchema.getSchema(kvSchemaInfo.getValue());
                return KeyValueSchema.of(keySchema, valueSchema, KeyValueSchemaInfo.decodeKeyValueEncodingType(schemaInfo));
            }
        }
        throw new IllegalArgumentException("Retrieve schema instance from schema info for type '" + (Object)((Object)schemaInfo.getType()) + "' is not supported yet");
    }
}

