/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.compaction;

import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.pulsar.broker.BookKeeperClientFactoryImpl;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.ServiceConfigurationUtils;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.compaction.TwoPhaseCompactor;
import org.apache.pulsar.shade.com.beust.jcommander.JCommander;
import org.apache.pulsar.shade.com.beust.jcommander.Parameter;
import org.apache.pulsar.shade.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.BookKeeper;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.configuration.PulsarConfigurationLoader;
import org.apache.pulsar.shade.org.apache.zookeeper.ZooKeeper;
import org.apache.pulsar.zookeeper.ZooKeeperClientFactory;
import org.apache.pulsar.zookeeper.ZookeeperBkClientFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactorTool {
    private static final Logger log = LoggerFactory.getLogger(CompactorTool.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Arguments arguments = new Arguments();
        JCommander jcommander = new JCommander(arguments);
        jcommander.setProgramName("PulsarTopicCompactor");
        jcommander.parse(args);
        if (arguments.help) {
            jcommander.usage();
            System.exit(-1);
        }
        if (StringUtils.isBlank(arguments.brokerConfigFile)) {
            jcommander.usage();
            throw new IllegalArgumentException("Need to specify a configuration file for broker");
        }
        ServiceConfiguration brokerConfig = (ServiceConfiguration)PulsarConfigurationLoader.create(arguments.brokerConfigFile, ServiceConfiguration.class);
        ClientBuilder clientBuilder = PulsarClient.builder();
        if (StringUtils.isNotBlank(brokerConfig.getBrokerClientAuthenticationPlugin())) {
            clientBuilder.authentication(brokerConfig.getBrokerClientAuthenticationPlugin(), brokerConfig.getBrokerClientAuthenticationParameters());
        }
        if (brokerConfig.getBrokerServicePortTls().isPresent()) {
            clientBuilder.serviceUrl(PulsarService.brokerUrlTls(ServiceConfigurationUtils.getAppliedAdvertisedAddress(brokerConfig), brokerConfig.getBrokerServicePortTls().get())).allowTlsInsecureConnection(brokerConfig.isTlsAllowInsecureConnection()).tlsTrustCertsFilePath(brokerConfig.getTlsCertificateFilePath());
        } else {
            clientBuilder.serviceUrl(PulsarService.brokerUrl(ServiceConfigurationUtils.getAppliedAdvertisedAddress(brokerConfig), brokerConfig.getBrokerServicePort().get()));
        }
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("compaction-%d").setDaemon(true).build());
        OrderedScheduler executor = OrderedScheduler.newSchedulerBuilder().build();
        ZookeeperBkClientFactoryImpl zkClientFactory = new ZookeeperBkClientFactoryImpl(executor);
        ZooKeeper zk = zkClientFactory.create(brokerConfig.getZookeeperServers(), ZooKeeperClientFactory.SessionType.ReadWrite, (int)brokerConfig.getZooKeeperSessionTimeoutMillis()).get();
        BookKeeperClientFactoryImpl bkClientFactory = new BookKeeperClientFactoryImpl();
        BookKeeper bk = bkClientFactory.create(brokerConfig, zk, Optional.empty(), null);
        try (PulsarClient pulsar = clientBuilder.build();){
            TwoPhaseCompactor compactor = new TwoPhaseCompactor(brokerConfig, pulsar, bk, scheduler);
            long ledgerId = compactor.compact(arguments.topic).get();
            log.info("Compaction of topic {} complete. Compacted to ledger {}", (Object)arguments.topic, (Object)ledgerId);
        }
        finally {
            bk.close();
            bkClientFactory.close();
            zk.close();
            scheduler.shutdownNow();
            executor.shutdown();
        }
    }

    private static class Arguments {
        @Parameter(names={"-c", "--broker-conf"}, description="Configuration file for Broker")
        private String brokerConfigFile = Paths.get("", new String[0]).toAbsolutePath().normalize().toString() + "/conf/broker.conf";
        @Parameter(names={"-t", "--topic"}, description="Topic to compact", required=true)
        private String topic;
        @Parameter(names={"-h", "--help"}, description="Show this help message")
        private boolean help = false;

        private Arguments() {
        }
    }
}

