/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.io.swagger.converter;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.pulsar.shade.com.fasterxml.jackson.annotation.JsonView;
import org.apache.pulsar.shade.io.swagger.converter.ModelConverter;
import org.apache.pulsar.shade.io.swagger.converter.ModelConverterContext;
import org.apache.pulsar.shade.io.swagger.models.ComposedModel;
import org.apache.pulsar.shade.io.swagger.models.Model;
import org.apache.pulsar.shade.io.swagger.models.ModelImpl;
import org.apache.pulsar.shade.io.swagger.models.properties.Property;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelConverterContextImpl
implements ModelConverterContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelConverterContextImpl.class);
    private final List<ModelConverter> converters;
    private final Map<String, Model> modelByName;
    private final HashMap<Type, Model> modelByType;
    private final Set<Type> processedTypes;
    private JsonView jsonView;

    public ModelConverterContextImpl(List<ModelConverter> converters) {
        this.converters = converters;
        this.modelByName = new TreeMap<String, Model>();
        this.modelByType = new HashMap();
        this.processedTypes = new HashSet<Type>();
    }

    public ModelConverterContextImpl(ModelConverter converter) {
        this(new ArrayList<ModelConverter>());
        this.converters.add(converter);
    }

    @Override
    public Iterator<ModelConverter> getConverters() {
        return this.converters.iterator();
    }

    @Override
    public void defineModel(String name, Model model) {
        this.defineModel(name, model, null, null);
    }

    @Override
    public void defineModel(String name, Model model, Type type, String prevName) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("defineModel %s %s", name, model));
        }
        this.modelByName.put(name, model);
        if (StringUtils.isNotBlank(prevName)) {
            this.modelByName.remove(prevName);
        }
        if (type != null) {
            this.modelByType.put(type, model);
        }
    }

    public Map<String, Model> getDefinedModels() {
        return Collections.unmodifiableMap(this.modelByName);
    }

    @Override
    public Property resolveProperty(Type type, Annotation[] annotations) {
        Iterator<ModelConverter> converters;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("resolveProperty %s", type));
        }
        if ((converters = this.getConverters()).hasNext()) {
            ModelConverter converter = converters.next();
            return converter.resolveProperty(type, this, annotations, converters);
        }
        return null;
    }

    @Override
    public Model resolve(Type type) {
        if (this.processedTypes.contains(type)) {
            return this.modelByType.get(type);
        }
        this.processedTypes.add(type);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("resolve %s", type));
        }
        Iterator<ModelConverter> converters = this.getConverters();
        Model resolved = null;
        if (converters.hasNext()) {
            ModelConverter converter = converters.next();
            LOGGER.debug("trying extension " + converter);
            resolved = converter.resolve(type, this, converters);
        }
        if (resolved != null) {
            ModelImpl impl;
            this.modelByType.put(type, resolved);
            Model resolvedImpl = resolved;
            if (resolvedImpl instanceof ComposedModel) {
                resolvedImpl = ((ComposedModel)resolved).getChild();
            }
            if (resolvedImpl instanceof ModelImpl && (impl = (ModelImpl)resolvedImpl).getName() != null) {
                this.modelByName.put(impl.getName(), resolved);
            }
        }
        return resolved;
    }

    @Override
    public JsonView getJsonView() {
        return this.jsonView;
    }

    @Override
    public void setJsonView(JsonView jsonView) {
        this.jsonView = jsonView;
    }
}

