/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.io.swagger.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.pulsar.shade.io.swagger.annotations.Extension;
import org.apache.pulsar.shade.io.swagger.annotations.ExtensionProperty;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;

public final class BaseReaderUtils {
    private BaseReaderUtils() {
    }

    public static Map<String, Object> parseExtensions(Extension[] extensions) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Extension extension : extensions) {
            String name = extension.name();
            String key = name.length() > 0 ? StringUtils.prependIfMissing(name, (CharSequence)"x-", new CharSequence[0]) : name;
            for (ExtensionProperty property : extension.properties()) {
                String propertyName = property.name();
                String propertyValue = property.value();
                if (!StringUtils.isNotBlank(propertyName) || !StringUtils.isNotBlank(propertyValue)) continue;
                if (key.isEmpty()) {
                    map.put(StringUtils.prependIfMissing(propertyName, (CharSequence)"x-", new CharSequence[0]), propertyValue);
                    continue;
                }
                Object value = map.get(key);
                if (value == null || !(value instanceof Map)) {
                    value = new HashMap();
                    map.put(key, value);
                }
                Map mapValue = (Map)value;
                mapValue.put(propertyName, propertyValue);
            }
        }
        return map;
    }
}

