/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.client;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.cache.Cache;
import org.apache.pulsar.shade.com.google.common.cache.CacheBuilder;
import org.apache.pulsar.shade.com.google.common.cache.CacheLoader;
import org.apache.pulsar.shade.io.netty.util.HashedWheelTimer;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.BKException;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.BookieInfoReader;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.BookiesHealthInfo;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.ITopologyAwareEnsemblePlacementPolicy;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.RackChangeNotifier;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.TopologyAwareEnsemblePlacementPolicy;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.WeightedRandomSelection;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.WeightedRandomSelectionImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.ReflectionUtils;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.Configurable;
import org.apache.pulsar.shade.org.apache.bookkeeper.feature.FeatureProvider;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.BookieId;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.BookieNode;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.DNSToSwitchMapping;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.NetworkTopologyImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.Node;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.ScriptBasedMapping;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.StabilizeNetworkTopology;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.BookieAddressResolver;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.Counter;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.Gauge;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.StatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.annotations.StatsDoc;
import org.apache.pulsar.shade.org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StatsDoc(name="bookkeeper_client", help="BookKeeper client stats")
public class RackawareEnsemblePlacementPolicyImpl
extends TopologyAwareEnsemblePlacementPolicy {
    static final Logger LOG = LoggerFactory.getLogger(RackawareEnsemblePlacementPolicyImpl.class);
    int maxWeightMultiple;
    protected int minNumRacksPerWriteQuorum;
    protected boolean enforceMinNumRacksPerWriteQuorum;
    protected boolean ignoreLocalNodeInPlacementPolicy;
    public static final String REPP_DNS_RESOLVER_CLASS = "reppDnsResolverClass";
    public static final String REPP_RANDOM_READ_REORDERING = "ensembleRandomReadReordering";
    static final int RACKNAME_DISTANCE_FROM_LEAVES = 1;
    static final int LOCAL_MASK = 0x1000000;
    static final int LOCAL_FAIL_MASK = 0x2000000;
    static final int REMOTE_MASK = 0x4000000;
    static final int REMOTE_FAIL_MASK = 0x8000000;
    static final int READ_ONLY_MASK = 0x10000000;
    static final int SLOW_MASK = 0x20000000;
    static final int UNAVAIL_MASK = 0x40000000;
    static final int MASK_BITS = -1048576;
    protected HashedWheelTimer timer;
    protected Cache<BookieId, Long> slowBookies;
    protected BookieNode localNode;
    protected boolean reorderReadsRandom = false;
    protected boolean enforceDurability = false;
    protected int stabilizePeriodSeconds = 0;
    protected int reorderThresholdPendingRequests = 0;
    protected StatsLogger statsLogger = null;
    @StatsDoc(name="READ_REQUESTS_REORDERED", help="The distribution of number of bookies reordered on each read request")
    protected OpStatsLogger readReorderedCounter = null;
    @StatsDoc(name="FAILED_TO_RESOLVE_NETWORK_LOCATION_COUNTER", help="Counter for number of times DNSResolverDecorator failed to resolve Network Location")
    protected Counter failedToResolveNetworkLocationCounter = null;
    @StatsDoc(name="NUM_WRITABLE_BOOKIES_IN_DEFAULT_RACK", help="Gauge for the number of writable Bookies in default rack")
    protected Gauge<Integer> numWritableBookiesInDefaultRack;
    private String defaultRack = "/default-rack";

    RackawareEnsemblePlacementPolicyImpl() {
        this(false);
    }

    RackawareEnsemblePlacementPolicyImpl(boolean enforceDurability) {
        this.enforceDurability = enforceDurability;
        this.topology = new NetworkTopologyImpl();
    }

    protected RackawareEnsemblePlacementPolicyImpl initialize(DNSToSwitchMapping dnsResolver, HashedWheelTimer timer, boolean reorderReadsRandom, int stabilizePeriodSeconds, int reorderThresholdPendingRequests, boolean isWeighted, int maxWeightMultiple, int minNumRacksPerWriteQuorum, boolean enforceMinNumRacksPerWriteQuorum, boolean ignoreLocalNodeInPlacementPolicy, StatsLogger statsLogger, BookieAddressResolver bookieAddressResolver) {
        Preconditions.checkNotNull(statsLogger, "statsLogger should not be null, use NullStatsLogger instead.");
        this.statsLogger = statsLogger;
        this.bookieAddressResolver = bookieAddressResolver;
        this.bookiesJoinedCounter = statsLogger.getOpStatsLogger("BOOKIES_JOINED");
        this.bookiesLeftCounter = statsLogger.getOpStatsLogger("BOOKIES_LEFT");
        this.readReorderedCounter = statsLogger.getOpStatsLogger("READ_REQUESTS_REORDERED");
        this.failedToResolveNetworkLocationCounter = statsLogger.getCounter("FAILED_TO_RESOLVE_NETWORK_LOCATION_COUNTER");
        this.numWritableBookiesInDefaultRack = new Gauge<Integer>(){

            @Override
            public Integer getDefaultValue() {
                return 0;
            }

            @Override
            public Integer getSample() {
                RackawareEnsemblePlacementPolicyImpl.this.rwLock.readLock().lock();
                try {
                    Integer n = RackawareEnsemblePlacementPolicyImpl.this.topology.countNumOfAvailableNodes(RackawareEnsemblePlacementPolicyImpl.this.getDefaultRack(), Collections.emptySet());
                    return n;
                }
                finally {
                    RackawareEnsemblePlacementPolicyImpl.this.rwLock.readLock().unlock();
                }
            }
        };
        this.statsLogger.registerGauge("NUM_WRITABLE_BOOKIES_IN_DEFAULT_RACK", this.numWritableBookiesInDefaultRack);
        this.reorderReadsRandom = reorderReadsRandom;
        this.stabilizePeriodSeconds = stabilizePeriodSeconds;
        this.reorderThresholdPendingRequests = reorderThresholdPendingRequests;
        this.dnsResolver = new TopologyAwareEnsemblePlacementPolicy.DNSResolverDecorator(dnsResolver, () -> this.getDefaultRack(), this.failedToResolveNetworkLocationCounter);
        this.timer = timer;
        this.minNumRacksPerWriteQuorum = minNumRacksPerWriteQuorum;
        this.enforceMinNumRacksPerWriteQuorum = enforceMinNumRacksPerWriteQuorum;
        this.ignoreLocalNodeInPlacementPolicy = ignoreLocalNodeInPlacementPolicy;
        this.topology = stabilizePeriodSeconds > 0 ? new StabilizeNetworkTopology(timer, stabilizePeriodSeconds) : new NetworkTopologyImpl();
        BookieNode bn = null;
        if (!ignoreLocalNodeInPlacementPolicy) {
            try {
                bn = this.createDummyLocalBookieNode(InetAddress.getLocalHost().getHostAddress());
            }
            catch (IOException e) {
                LOG.error("Failed to get local host address : ", (Throwable)e);
            }
        } else {
            LOG.info("Ignoring LocalNode in Placementpolicy");
        }
        this.localNode = bn;
        LOG.info("Initialize rackaware ensemble placement policy @ {} @ {} : {}.", new Object[]{this.localNode, null == this.localNode ? "Unknown" : this.localNode.getNetworkLocation(), dnsResolver.getClass().getName()});
        this.isWeighted = isWeighted;
        if (this.isWeighted) {
            this.maxWeightMultiple = maxWeightMultiple;
            this.weightedSelection = new WeightedRandomSelectionImpl(this.maxWeightMultiple);
            LOG.info("Weight based placement with max multiple of " + this.maxWeightMultiple);
        } else {
            LOG.info("Not weighted");
        }
        return this;
    }

    public RackawareEnsemblePlacementPolicyImpl withDefaultRack(String rack) {
        Preconditions.checkNotNull(rack, "Default rack cannot be null");
        this.defaultRack = rack;
        return this;
    }

    public String getDefaultRack() {
        return this.defaultRack;
    }

    @Override
    public RackawareEnsemblePlacementPolicyImpl initialize(ClientConfiguration conf, Optional<DNSToSwitchMapping> optionalDnsResolver, HashedWheelTimer timer, FeatureProvider featureProvider, StatsLogger statsLogger, BookieAddressResolver bookieAddressResolver) {
        DNSToSwitchMapping dnsResolver;
        this.bookieAddressResolver = bookieAddressResolver;
        if (optionalDnsResolver.isPresent()) {
            dnsResolver = optionalDnsResolver.get();
        } else {
            String dnsResolverName = conf.getString(REPP_DNS_RESOLVER_CLASS, ScriptBasedMapping.class.getName());
            try {
                dnsResolver = ReflectionUtils.newInstance(dnsResolverName, DNSToSwitchMapping.class);
                if (dnsResolver instanceof Configurable) {
                    ((Configurable)((Object)dnsResolver)).setConf(conf);
                }
                if (dnsResolver instanceof RackChangeNotifier) {
                    ((RackChangeNotifier)((Object)dnsResolver)).registerRackChangeListener(this);
                }
            }
            catch (RuntimeException re) {
                if (!conf.getEnforceMinNumRacksPerWriteQuorum()) {
                    LOG.error("Failed to initialize DNS Resolver {}, used default subnet resolver : {}", new Object[]{dnsResolverName, re, re.getMessage()});
                    dnsResolver = new TopologyAwareEnsemblePlacementPolicy.DefaultResolver(() -> this.getDefaultRack());
                }
                throw re;
            }
        }
        this.slowBookies = CacheBuilder.newBuilder().expireAfterWrite(conf.getBookieFailureHistoryExpirationMSec(), TimeUnit.MILLISECONDS).build(new CacheLoader<BookieId, Long>(){

            @Override
            public Long load(BookieId key) throws Exception {
                return -1L;
            }
        });
        return this.initialize(dnsResolver, timer, conf.getBoolean(REPP_RANDOM_READ_REORDERING, false), conf.getNetworkTopologyStabilizePeriodSeconds(), conf.getReorderThresholdPendingRequests(), conf.getDiskWeightBasedPlacementEnabled(), conf.getBookieMaxWeightMultipleForWeightBasedPlacement(), conf.getMinNumRacksPerWriteQuorum(), conf.getEnforceMinNumRacksPerWriteQuorum(), conf.getIgnoreLocalNodeInPlacementPolicy(), statsLogger, bookieAddressResolver);
    }

    @Override
    public void uninitalize() {
    }

    protected Set<BookieId> addDefaultRackBookiesIfMinNumRacksIsEnforced(Set<BookieId> excludeBookies) {
        Set<BookieId> comprehensiveExclusionBookiesSet;
        if (this.enforceMinNumRacksPerWriteQuorum) {
            HashSet<BookieId> bookiesInDefaultRack = null;
            Set<Node> defaultRackLeaves = this.topology.getLeaves(this.getDefaultRack());
            for (Node node : defaultRackLeaves) {
                if (node instanceof BookieNode) {
                    if (bookiesInDefaultRack == null) {
                        bookiesInDefaultRack = new HashSet<BookieId>(excludeBookies);
                    }
                    bookiesInDefaultRack.add(((BookieNode)node).getAddr());
                    continue;
                }
                LOG.error("found non-BookieNode: {} as leaf of defaultrack: {}", (Object)node, (Object)this.getDefaultRack());
            }
            if (bookiesInDefaultRack == null || bookiesInDefaultRack.isEmpty()) {
                comprehensiveExclusionBookiesSet = excludeBookies;
            } else {
                comprehensiveExclusionBookiesSet = new HashSet<BookieId>(excludeBookies);
                comprehensiveExclusionBookiesSet.addAll((Collection<BookieId>)bookiesInDefaultRack);
                LOG.info("enforceMinNumRacksPerWriteQuorum is enabled, so Excluding bookies of defaultRack: {}", bookiesInDefaultRack);
            }
        } else {
            comprehensiveExclusionBookiesSet = excludeBookies;
        }
        return comprehensiveExclusionBookiesSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnsemblePlacementPolicy.PlacementResult<List<BookieId>> newEnsemble(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, Set<BookieId> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        this.rwLock.readLock().lock();
        try {
            EnsemblePlacementPolicy.PlacementResult<List<BookieId>> newEnsembleResult;
            Set<BookieId> comprehensiveExclusionBookiesSet = this.addDefaultRackBookiesIfMinNumRacksIsEnforced(excludeBookies);
            EnsemblePlacementPolicy.PlacementResult<List<BookieId>> placementResult = newEnsembleResult = this.newEnsembleInternal(ensembleSize, writeQuorumSize, ackQuorumSize, comprehensiveExclusionBookiesSet, null, null);
            return placementResult;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    public EnsemblePlacementPolicy.PlacementResult<List<BookieId>> newEnsemble(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Set<BookieId> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Ensemble<BookieNode> parentEnsemble, ITopologyAwareEnsemblePlacementPolicy.Predicate<BookieNode> parentPredicate) throws BKException.BKNotEnoughBookiesException {
        return this.newEnsembleInternal(ensembleSize, writeQuorumSize, ackQuorumSize, excludeBookies, parentEnsemble, parentPredicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EnsemblePlacementPolicy.PlacementResult<List<BookieId>> newEnsembleInternal(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Set<BookieId> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Ensemble<BookieNode> parentEnsemble, ITopologyAwareEnsemblePlacementPolicy.Predicate<BookieNode> parentPredicate) throws BKException.BKNotEnoughBookiesException {
        this.rwLock.readLock().lock();
        try {
            Set<Node> excludeNodes = this.convertBookiesToNodes(excludeBookies);
            int minNumRacksPerWriteQuorumForThisEnsemble = Math.min(writeQuorumSize, this.minNumRacksPerWriteQuorum);
            TopologyAwareEnsemblePlacementPolicy.RRTopologyAwareCoverageEnsemble ensemble = new TopologyAwareEnsemblePlacementPolicy.RRTopologyAwareCoverageEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, 1, parentEnsemble, parentPredicate, minNumRacksPerWriteQuorumForThisEnsemble);
            Node prevNode = null;
            int numRacks = this.topology.getNumOfRacks();
            if (numRacks < 2) {
                if (this.enforceMinNumRacksPerWriteQuorum && minNumRacksPerWriteQuorumForThisEnsemble > 1) {
                    LOG.error("Only one rack available and minNumRacksPerWriteQuorum is enforced, so giving up");
                    throw new BKException.BKNotEnoughBookiesException();
                }
                List<BookieNode> bns = this.selectRandom(ensembleSize, excludeNodes, TopologyAwareEnsemblePlacementPolicy.TruePredicate.INSTANCE, ensemble);
                ArrayList<BookieId> addrs = new ArrayList<BookieId>(ensembleSize);
                for (BookieNode bn : bns) {
                    addrs.add(bn.getAddr());
                }
                EnsemblePlacementPolicy.PlacementResult placementResult = EnsemblePlacementPolicy.PlacementResult.of(addrs, EnsemblePlacementPolicy.PlacementPolicyAdherence.FAIL);
                return placementResult;
            }
            for (int i = 0; i < ensembleSize; ++i) {
                String curRack = null == prevNode ? (null == this.localNode || this.defaultRack.equals(this.localNode.getNetworkLocation()) ? "" : this.localNode.getNetworkLocation()) : "~" + prevNode.getNetworkLocation();
                boolean firstBookieInTheEnsemble = null == prevNode;
                prevNode = this.selectFromNetworkLocation(curRack, (Set)excludeNodes, (ITopologyAwareEnsemblePlacementPolicy.Predicate)ensemble, (ITopologyAwareEnsemblePlacementPolicy.Ensemble)ensemble, !this.enforceMinNumRacksPerWriteQuorum || firstBookieInTheEnsemble);
            }
            List<BookieId> bookieList = ensemble.toList();
            if (ensembleSize != bookieList.size()) {
                LOG.error("Not enough {} bookies are available to form an ensemble : {}.", (Object)ensembleSize, bookieList);
                throw new BKException.BKNotEnoughBookiesException();
            }
            EnsemblePlacementPolicy.PlacementResult<List<BookieId>> placementResult = EnsemblePlacementPolicy.PlacementResult.of(bookieList, this.isEnsembleAdheringToPlacementPolicy(bookieList, writeQuorumSize, ackQuorumSize));
            return placementResult;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnsemblePlacementPolicy.PlacementResult<BookieId> replaceBookie(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, List<BookieId> currentEnsemble, BookieId bookieToReplace, Set<BookieId> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        this.rwLock.readLock().lock();
        try {
            excludeBookies = this.addDefaultRackBookiesIfMinNumRacksIsEnforced(excludeBookies);
            excludeBookies.addAll(currentEnsemble);
            BookieNode bn = (BookieNode)this.knownBookies.get(bookieToReplace);
            if (null == bn) {
                bn = this.createBookieNode(bookieToReplace);
            }
            Set<Node> ensembleNodes = this.convertBookiesToNodes(currentEnsemble);
            Set<Node> excludeNodes = this.convertBookiesToNodes(excludeBookies);
            excludeNodes.addAll(ensembleNodes);
            excludeNodes.add(bn);
            ensembleNodes.remove(bn);
            Set<String> networkLocationsToBeExcluded = RackawareEnsemblePlacementPolicyImpl.getNetworkLocations(ensembleNodes);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Try to choose a new bookie to replace {} from ensemble {}, excluding {}.", new Object[]{bookieToReplace, ensembleNodes, excludeNodes});
            }
            Node candidate = this.selectFromNetworkLocation(bn.getNetworkLocation(), (Set)networkLocationsToBeExcluded, (Set)excludeNodes, (ITopologyAwareEnsemblePlacementPolicy.Predicate)TopologyAwareEnsemblePlacementPolicy.TruePredicate.INSTANCE, (ITopologyAwareEnsemblePlacementPolicy.Ensemble)TopologyAwareEnsemblePlacementPolicy.EnsembleForReplacementWithNoConstraints.INSTANCE, !this.enforceMinNumRacksPerWriteQuorum);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Bookie {} is chosen to replace bookie {}.", (Object)candidate, (Object)bn);
            }
            BookieId candidateAddr = ((BookieNode)candidate).getAddr();
            ArrayList<BookieId> newEnsemble = new ArrayList<BookieId>(currentEnsemble);
            if (currentEnsemble.isEmpty()) {
                newEnsemble.add(candidateAddr);
            } else {
                newEnsemble.set(currentEnsemble.indexOf(bookieToReplace), candidateAddr);
            }
            EnsemblePlacementPolicy.PlacementResult<BookieId> placementResult = EnsemblePlacementPolicy.PlacementResult.of(candidateAddr, this.isEnsembleAdheringToPlacementPolicy(newEnsemble, writeQuorumSize, ackQuorumSize));
            return placementResult;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    public BookieNode selectFromNetworkLocation(String networkLoc, Set<Node> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Predicate<BookieNode> predicate, ITopologyAwareEnsemblePlacementPolicy.Ensemble<BookieNode> ensemble, boolean fallbackToRandom) throws BKException.BKNotEnoughBookiesException {
        try {
            return this.selectRandomFromRack(networkLoc, excludeBookies, predicate, ensemble);
        }
        catch (BKException.BKNotEnoughBookiesException e) {
            if (!fallbackToRandom) {
                LOG.error("Failed to choose a bookie from {} : excluded {}, enforceMinNumRacksPerWriteQuorum is enabled so giving up.", (Object)networkLoc, excludeBookies);
                throw e;
            }
            LOG.warn("Failed to choose a bookie from {} : excluded {}, fallback to choose bookie randomly from the cluster.", (Object)networkLoc, excludeBookies);
            return this.selectRandom(1, excludeBookies, predicate, ensemble).get(0);
        }
    }

    @Override
    public BookieNode selectFromNetworkLocation(String networkLoc, Set<String> excludeRacks, Set<Node> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Predicate<BookieNode> predicate, ITopologyAwareEnsemblePlacementPolicy.Ensemble<BookieNode> ensemble, boolean fallbackToRandom) throws BKException.BKNotEnoughBookiesException {
        try {
            return this.selectRandomFromRack(networkLoc, excludeBookies, predicate, ensemble);
        }
        catch (BKException.BKNotEnoughBookiesException e) {
            return this.selectFromNetworkLocation((Set)excludeRacks, (Set)excludeBookies, (ITopologyAwareEnsemblePlacementPolicy.Predicate)predicate, (ITopologyAwareEnsemblePlacementPolicy.Ensemble)ensemble, fallbackToRandom);
        }
    }

    @Override
    public BookieNode selectFromNetworkLocation(Set<String> excludeRacks, Set<Node> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Predicate<BookieNode> predicate, ITopologyAwareEnsemblePlacementPolicy.Ensemble<BookieNode> ensemble, boolean fallbackToRandom) throws BKException.BKNotEnoughBookiesException {
        ArrayList<BookieNode> knownNodes = new ArrayList<BookieNode>(this.knownBookies.values());
        HashSet<Node> fullExclusionBookiesList = new HashSet<Node>(excludeBookies);
        for (BookieNode knownNode : knownNodes) {
            if (!excludeRacks.contains(knownNode.getNetworkLocation())) continue;
            fullExclusionBookiesList.add(knownNode);
        }
        try {
            return this.selectRandomInternal(knownNodes, 1, fullExclusionBookiesList, predicate, ensemble).get(0);
        }
        catch (BKException.BKNotEnoughBookiesException e) {
            if (!fallbackToRandom) {
                LOG.error("Failed to choose a bookie excluding Racks: {} Nodes: {}, enforceMinNumRacksPerWriteQuorum is enabled so giving up.", excludeRacks, excludeBookies);
                throw e;
            }
            LOG.warn("Failed to choose a bookie: excluded {}, fallback to choose bookie randomly from the cluster.", excludeBookies);
            return this.selectRandom(1, excludeBookies, predicate, ensemble).get(0);
        }
    }

    private WeightedRandomSelection<BookieNode> prepareForWeightedSelection(List<Node> leaves) {
        HashMap rackMap = new HashMap();
        for (Node n : leaves) {
            if (!(n instanceof BookieNode)) continue;
            BookieNode bookie = (BookieNode)n;
            if (this.bookieInfoMap.containsKey(bookie)) {
                rackMap.put(bookie, this.bookieInfoMap.get(bookie));
                continue;
            }
            rackMap.put(bookie, new BookieInfoReader.BookieInfo());
        }
        if (rackMap.size() == 0) {
            return null;
        }
        WeightedRandomSelectionImpl<BookieNode> wRSelection = new WeightedRandomSelectionImpl<BookieNode>(this.maxWeightMultiple);
        wRSelection.updateMap(rackMap);
        return wRSelection;
    }

    protected BookieNode selectRandomFromRack(String netPath, Set<Node> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Predicate<BookieNode> predicate, ITopologyAwareEnsemblePlacementPolicy.Ensemble<BookieNode> ensemble) throws BKException.BKNotEnoughBookiesException {
        block8: {
            Node n;
            WeightedRandomSelection<BookieNode> wRSelection = null;
            ArrayList<Node> leaves = new ArrayList<Node>(this.topology.getLeaves(netPath));
            if (!this.isWeighted) {
                Collections.shuffle(leaves);
            } else {
                if (CollectionUtils.subtract(leaves, excludeBookies).size() < 1) {
                    throw new BKException.BKNotEnoughBookiesException();
                }
                wRSelection = this.prepareForWeightedSelection(leaves);
                if (wRSelection == null) {
                    throw new BKException.BKNotEnoughBookiesException();
                }
            }
            Iterator it = leaves.iterator();
            HashSet<Node> bookiesSeenSoFar = new HashSet<Node>();
            do {
                if (this.isWeighted) {
                    if (bookiesSeenSoFar.size() != leaves.size()) {
                        n = wRSelection.getNextRandom();
                        bookiesSeenSoFar.add(n);
                        continue;
                    }
                    break block8;
                }
                if (!it.hasNext()) break block8;
                n = (Node)it.next();
            } while (excludeBookies.contains(n) || !(n instanceof BookieNode) || !predicate.apply((BookieNode)n, ensemble));
            BookieNode bn = (BookieNode)n;
            if (ensemble.addNode(bn)) {
                excludeBookies.add(bn);
            }
            return bn;
        }
        throw new BKException.BKNotEnoughBookiesException();
    }

    protected List<BookieNode> selectRandom(int numBookies, Set<Node> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Predicate<BookieNode> predicate, ITopologyAwareEnsemblePlacementPolicy.Ensemble<BookieNode> ensemble) throws BKException.BKNotEnoughBookiesException {
        return this.selectRandomInternal(null, numBookies, excludeBookies, predicate, ensemble);
    }

    protected List<BookieNode> selectRandomInternal(List<BookieNode> bookiesToSelectFrom, int numBookies, Set<Node> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Predicate<BookieNode> predicate, ITopologyAwareEnsemblePlacementPolicy.Ensemble<BookieNode> ensemble) throws BKException.BKNotEnoughBookiesException {
        WeightedRandomSelectionImpl<BookieNode> wRSelection = null;
        if (bookiesToSelectFrom == null) {
            wRSelection = this.weightedSelection;
            bookiesToSelectFrom = new ArrayList(this.knownBookies.values());
        }
        if (this.isWeighted) {
            if (CollectionUtils.subtract(bookiesToSelectFrom, excludeBookies).size() < numBookies) {
                throw new BKException.BKNotEnoughBookiesException();
            }
            if (wRSelection == null) {
                HashMap rackMap = new HashMap();
                for (BookieNode n : bookiesToSelectFrom) {
                    if (excludeBookies.contains(n)) continue;
                    if (this.bookieInfoMap.containsKey(n)) {
                        rackMap.put(n, this.bookieInfoMap.get(n));
                        continue;
                    }
                    rackMap.put(n, new BookieInfoReader.BookieInfo());
                }
                wRSelection = new WeightedRandomSelectionImpl<BookieNode>(this.maxWeightMultiple);
                wRSelection.updateMap(rackMap);
            }
        } else {
            Collections.shuffle(bookiesToSelectFrom);
        }
        ArrayList<BookieNode> newBookies = new ArrayList<BookieNode>(numBookies);
        Iterator<BookieNode> it = bookiesToSelectFrom.iterator();
        HashSet<BookieNode> bookiesSeenSoFar = new HashSet<BookieNode>();
        while (numBookies > 0) {
            BookieNode bookie;
            if (this.isWeighted) {
                if (bookiesSeenSoFar.size() == bookiesToSelectFrom.size()) break;
                bookie = (BookieNode)wRSelection.getNextRandom();
                bookiesSeenSoFar.add(bookie);
            } else {
                if (!it.hasNext()) break;
                bookie = it.next();
            }
            if (excludeBookies.contains(bookie) || this.enforceDurability && !predicate.apply(bookie, ensemble) || !ensemble.addNode(bookie)) continue;
            excludeBookies.add(bookie);
            newBookies.add(bookie);
            --numBookies;
        }
        if (numBookies == 0) {
            return newBookies;
        }
        LOG.warn("Failed to find {} bookies : excludeBookies {}, allBookies {}.", new Object[]{numBookies, excludeBookies, bookiesToSelectFrom});
        throw new BKException.BKNotEnoughBookiesException();
    }

    @Override
    public void registerSlowBookie(BookieId bookieSocketAddress, long entryId) {
        if (this.reorderThresholdPendingRequests <= 0) {
            this.slowBookies.put(bookieSocketAddress, entryId);
        }
    }

    @Override
    public DistributionSchedule.WriteSet reorderReadSequence(List<BookieId> ensemble, BookiesHealthInfo bookiesHealthInfo, DistributionSchedule.WriteSet writeSet) {
        HashMap<Integer, String> writeSetWithRegion = new HashMap<Integer, String>();
        for (int i = 0; i < writeSet.size(); ++i) {
            writeSetWithRegion.put(writeSet.get(i), "");
        }
        return this.reorderReadSequenceWithRegion(ensemble, writeSet, writeSetWithRegion, bookiesHealthInfo, false, "", writeSet.size());
    }

    DistributionSchedule.WriteSet reorderReadSequenceWithRegion(List<BookieId> ensemble, DistributionSchedule.WriteSet writeSet, Map<Integer, String> writeSetWithRegion, BookiesHealthInfo bookiesHealthInfo, boolean regionAware, String myRegion, int remoteNodeInReorderSequence) {
        int i;
        int i2;
        boolean useRegionAware = regionAware && !myRegion.equals("UnknownRegion");
        int ensembleSize = ensemble.size();
        boolean isAnyBookieUnavailable = false;
        if (useRegionAware || this.reorderReadsRandom) {
            isAnyBookieUnavailable = true;
        } else {
            for (int i3 = 0; i3 < ensemble.size(); ++i3) {
                BookieId bookieAddr = ensemble.get(i3);
                if ((this.knownBookies.containsKey(bookieAddr) || this.readOnlyBookies.contains(bookieAddr)) && this.slowBookies.getIfPresent(bookieAddr) == null) continue;
                isAnyBookieUnavailable = true;
                break;
            }
        }
        boolean reordered = false;
        if (this.reorderThresholdPendingRequests > 0) {
            long[] pendingReqs = new long[writeSet.size()];
            int bestBookieIdx = -1;
            for (int i4 = 0; i4 < writeSet.size(); ++i4) {
                pendingReqs[i4] = bookiesHealthInfo.getBookiePendingRequests(ensemble.get(writeSet.get(i4)));
                if (bestBookieIdx >= 0 && pendingReqs[i4] >= pendingReqs[bestBookieIdx]) continue;
                bestBookieIdx = i4;
            }
            if (bestBookieIdx > 0 && pendingReqs[0] >= pendingReqs[bestBookieIdx] + (long)this.reorderThresholdPendingRequests) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("read set reordered from {} ({} pending) to {} ({} pending)", new Object[]{ensemble.get(writeSet.get(0)), pendingReqs[0], ensemble.get(writeSet.get(bestBookieIdx)), pendingReqs[bestBookieIdx]});
                }
                writeSet.moveAndShift(bestBookieIdx, 0);
                reordered = true;
            }
        }
        if (!isAnyBookieUnavailable) {
            if (reordered) {
                this.readReorderedCounter.registerSuccessfulValue(1L);
            }
            return writeSet;
        }
        for (i2 = 0; i2 < writeSet.size(); ++i2) {
            long slowIdx;
            long numPendingReqs;
            int idx = writeSet.get(i2);
            BookieId address = ensemble.get(idx);
            String region = writeSetWithRegion.get(idx);
            Long lastFailedEntryOnBookie = bookiesHealthInfo.getBookieFailureHistory(address);
            if (null == this.knownBookies.get(address)) {
                if (null == this.readOnlyBookies || !this.readOnlyBookies.contains(address)) {
                    writeSet.set(i2, idx | 0x40000000);
                    continue;
                }
                if (this.slowBookies.getIfPresent(address) != null) {
                    numPendingReqs = bookiesHealthInfo.getBookiePendingRequests(address);
                    slowIdx = numPendingReqs * (long)ensembleSize + (long)idx;
                    writeSet.set(i2, (int)(slowIdx & 0xFFFFFL) | 0x20000000);
                    continue;
                }
                writeSet.set(i2, idx | 0x10000000);
                continue;
            }
            if (lastFailedEntryOnBookie < 0L) {
                if (this.slowBookies.getIfPresent(address) != null) {
                    numPendingReqs = bookiesHealthInfo.getBookiePendingRequests(address);
                    slowIdx = numPendingReqs * (long)ensembleSize + (long)idx;
                    writeSet.set(i2, (int)(slowIdx & 0xFFFFFL) | 0x20000000);
                    continue;
                }
                if (useRegionAware && !myRegion.equals(region)) {
                    writeSet.set(i2, idx | 0x4000000);
                    continue;
                }
                writeSet.set(i2, idx | 0x1000000);
                continue;
            }
            long failIdx = lastFailedEntryOnBookie * (long)ensembleSize + (long)idx;
            if (useRegionAware && !myRegion.equals(region)) {
                writeSet.set(i2, (int)(failIdx & 0xFFFFFL) | 0x8000000);
                continue;
            }
            writeSet.set(i2, (int)(failIdx & 0xFFFFFL) | 0x2000000);
        }
        for (i2 = 0; i2 < writeSet.size(); ++i2) {
            writeSet.set(i2, writeSet.get(i2) | (i2 & 0xF) << 20);
        }
        writeSet.sort();
        for (i2 = 0; i2 < writeSet.size(); ++i2) {
            writeSet.set(i2, writeSet.get(i2) & 0xFF0FFFFF);
        }
        if (this.reorderReadsRandom) {
            RackawareEnsemblePlacementPolicyImpl.shuffleWithMask(writeSet, 0x1000000, -1048576);
            RackawareEnsemblePlacementPolicyImpl.shuffleWithMask(writeSet, 0x4000000, -1048576);
            RackawareEnsemblePlacementPolicyImpl.shuffleWithMask(writeSet, 0x10000000, -1048576);
            RackawareEnsemblePlacementPolicyImpl.shuffleWithMask(writeSet, 0x40000000, -1048576);
        }
        for (i2 = 0; i2 < writeSet.size(); ++i2) {
            int mask = writeSet.get(i2) & 0xFFF00000;
            int idx = (writeSet.get(i2) & 0xFFFFF) % ensembleSize;
            if (mask == 0x2000000) {
                writeSet.set(i2, 0x1000000 | idx);
                continue;
            }
            if (mask == 0x8000000) {
                writeSet.set(i2, 0x4000000 | idx);
                continue;
            }
            if (mask != 0x20000000) continue;
            writeSet.set(i2, 0x20000000 | idx);
        }
        int firstRemote = -1;
        for (i = 0; i < writeSet.size(); ++i) {
            if ((writeSet.get(i) & 0xFFF00000) != 0x4000000) continue;
            firstRemote = i;
            break;
        }
        if (firstRemote != -1) {
            for (i = 0; i < remoteNodeInReorderSequence && i < writeSet.size() && (writeSet.get(i) & 0xFFF00000) == 0x1000000; ++i) {
            }
            writeSet.moveAndShift(firstRemote, i);
        }
        for (i = 0; i < writeSet.size(); ++i) {
            writeSet.set(i, writeSet.get(i) & 0xFFFFF);
        }
        this.readReorderedCounter.registerSuccessfulValue(1L);
        return writeSet;
    }

    @Override
    public EnsemblePlacementPolicy.PlacementPolicyAdherence isEnsembleAdheringToPlacementPolicy(List<BookieId> ensembleList, int writeQuorumSize, int ackQuorumSize) {
        int ensembleSize = ensembleList.size();
        int minNumRacksPerWriteQuorumForThisEnsemble = Math.min(writeQuorumSize, this.minNumRacksPerWriteQuorum);
        HashSet<String> racksInQuorum = new HashSet<String>();
        for (int i = 0; i < ensembleList.size(); ++i) {
            racksInQuorum.clear();
            for (int j = 0; j < writeQuorumSize; ++j) {
                BookieId bookie = ensembleList.get((i + j) % ensembleSize);
                try {
                    racksInQuorum.add(((BookieNode)this.knownBookies.get(bookie)).getNetworkLocation());
                    continue;
                }
                catch (Exception e) {
                    LOG.warn("Received exception while trying to get network location of bookie: {}", (Object)bookie, (Object)e);
                }
            }
            if (racksInQuorum.size() >= minNumRacksPerWriteQuorumForThisEnsemble && (!this.enforceMinNumRacksPerWriteQuorum || !racksInQuorum.contains(this.getDefaultRack()))) continue;
            return EnsemblePlacementPolicy.PlacementPolicyAdherence.FAIL;
        }
        return EnsemblePlacementPolicy.PlacementPolicyAdherence.MEETS_STRICT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean areAckedBookiesAdheringToPlacementPolicy(Set<BookieId> ackedBookies, int writeQuorumSize, int ackQuorumSize) {
        HashSet<String> rackCounter = new HashSet<String>();
        int minWriteQuorumNumRacksPerWriteQuorum = Math.min(writeQuorumSize, this.minNumRacksPerWriteQuorum);
        ReentrantReadWriteLock.ReadLock readLock = this.rwLock.readLock();
        readLock.lock();
        try {
            for (BookieId bookie : ackedBookies) {
                rackCounter.add(((BookieNode)this.knownBookies.get(bookie)).getNetworkLocation());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("areAckedBookiesAdheringToPlacementPolicy returning {} because number of racks = {} and minNumRacksPerWriteQuorum = {}", new Object[]{rackCounter.size() >= this.minNumRacksPerWriteQuorum, rackCounter.size(), this.minNumRacksPerWriteQuorum});
            }
        }
        finally {
            readLock.unlock();
        }
        return rackCounter.size() >= minWriteQuorumNumRacksPerWriteQuorum;
    }
}

