/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.common.coder;

import java.nio.charset.StandardCharsets;
import org.apache.pulsar.shade.com.google.common.base.Utf8;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.ByteBufUtil;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.coder.Coder;

public final class StringUtf8Coder
implements Coder<String> {
    private static final StringUtf8Coder INSTANCE = new StringUtf8Coder();

    public static StringUtf8Coder of() {
        return INSTANCE;
    }

    @Override
    public void encode(String value, ByteBuf destBuf) {
        destBuf.writeBytes(value.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public int getSerializedSize(String value) {
        return Utf8.encodedLength(value);
    }

    @Override
    public String decode(byte[] data) {
        return new String(data, StandardCharsets.UTF_8);
    }

    @Override
    public String decode(ByteBuf data) {
        byte[] bytes = ByteBufUtil.getBytes(data);
        return this.decode(bytes);
    }

    private StringUtf8Coder() {
    }
}

