/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.common.resolver;

import io.grpc.Attributes;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import io.grpc.internal.DnsNameResolverProvider;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import org.apache.pulsar.shade.com.google.common.base.Function;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.net.ServiceURI;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.resolver.NameResolverFactoryProvider;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.resolver.NameResolverProviderFactory;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.resolver.StaticNameResolver;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.SharedResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceNameResolverProvider
extends NameResolverFactoryProvider {
    private static final Logger log = LoggerFactory.getLogger(ServiceNameResolverProvider.class);
    private final DnsNameResolverProvider dnsProvider = new DnsNameResolverProvider();
    private final SharedResourceManager.Resource<ExecutorService> executorResource = new SharedResourceManager.Resource<ExecutorService>(){

        @Override
        public ExecutorService create() {
            return Executors.newSingleThreadScheduledExecutor();
        }

        @Override
        public void close(ExecutorService instance) {
            instance.shutdown();
        }
    };

    protected boolean isAvailable() {
        return true;
    }

    protected int priority() {
        return 10;
    }

    @Nullable
    public NameResolver newNameResolver(URI targetUri, Attributes params) {
        ServiceURI serviceURI;
        try {
            serviceURI = ServiceURI.create(targetUri);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            log.info("ServiceNameResolverProvider doesn't know how to resolve {} : cause {}", (Object)targetUri, (Object)e.getMessage());
            return null;
        }
        if (null == serviceURI.getServiceName() || "bk".equals(serviceURI.getServiceName())) {
            String[] hosts = serviceURI.getServiceHosts();
            if (hosts.length == 0) {
                return null;
            }
            if (hosts.length == 1) {
                URI dnsUri = URI.create("dns:///" + hosts[0]);
                return this.dnsProvider.newNameResolver(dnsUri, params);
            }
            ArrayList<String> hostList = new ArrayList<String>();
            for (String host : hosts) {
                hostList.add(host);
            }
            List<URI> hostUris = Lists.transform(hostList, new Function<String, URI>(){

                @Override
                @Nullable
                public URI apply(@Nullable String host) {
                    return URI.create("//" + host);
                }
            });
            return new StaticNameResolver("static", this.executorResource, hostUris);
        }
        return null;
    }

    public String getDefaultScheme() {
        return "bk";
    }

    @Override
    public NameResolver.Factory toFactory() {
        return new NameResolverProviderFactory(Lists.newArrayList(new NameResolverProvider[]{this}));
    }
}

