/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.mledger;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.annotation.InterfaceStability;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedLedgerMXBean;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.Position;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.PulsarApi;

@InterfaceAudience.LimitedPrivate
@InterfaceStability.Stable
public interface ManagedLedger {
    public String getName();

    public Position addEntry(byte[] var1) throws InterruptedException, ManagedLedgerException;

    public void asyncAddEntry(byte[] var1, AsyncCallbacks.AddEntryCallback var2, Object var3);

    public Position addEntry(byte[] var1, int var2, int var3) throws InterruptedException, ManagedLedgerException;

    public void asyncAddEntry(byte[] var1, int var2, int var3, AsyncCallbacks.AddEntryCallback var4, Object var5);

    public void asyncAddEntry(ByteBuf var1, AsyncCallbacks.AddEntryCallback var2, Object var3);

    public ManagedCursor openCursor(String var1) throws InterruptedException, ManagedLedgerException;

    public ManagedCursor openCursor(String var1, PulsarApi.CommandSubscribe.InitialPosition var2) throws InterruptedException, ManagedLedgerException;

    public ManagedCursor openCursor(String var1, PulsarApi.CommandSubscribe.InitialPosition var2, Map<String, Long> var3) throws InterruptedException, ManagedLedgerException;

    public ManagedCursor newNonDurableCursor(Position var1) throws ManagedLedgerException;

    public ManagedCursor newNonDurableCursor(Position var1, String var2) throws ManagedLedgerException;

    public ManagedCursor newNonDurableCursor(Position var1, String var2, PulsarApi.CommandSubscribe.InitialPosition var3) throws ManagedLedgerException;

    public void asyncDeleteCursor(String var1, AsyncCallbacks.DeleteCursorCallback var2, Object var3);

    public void deleteCursor(String var1) throws InterruptedException, ManagedLedgerException;

    public void asyncOpenCursor(String var1, AsyncCallbacks.OpenCursorCallback var2, Object var3);

    public void asyncOpenCursor(String var1, PulsarApi.CommandSubscribe.InitialPosition var2, AsyncCallbacks.OpenCursorCallback var3, Object var4);

    public void asyncOpenCursor(String var1, PulsarApi.CommandSubscribe.InitialPosition var2, Map<String, Long> var3, AsyncCallbacks.OpenCursorCallback var4, Object var5);

    public Iterable<ManagedCursor> getCursors();

    public Iterable<ManagedCursor> getActiveCursors();

    public long getNumberOfEntries();

    public long getNumberOfActiveEntries();

    public long getTotalSize();

    public long getEstimatedBacklogSize();

    public long getOffloadedSize();

    public void asyncTerminate(AsyncCallbacks.TerminateCallback var1, Object var2);

    public Position terminate() throws InterruptedException, ManagedLedgerException;

    public void close() throws InterruptedException, ManagedLedgerException;

    public void asyncClose(AsyncCallbacks.CloseCallback var1, Object var2);

    public ManagedLedgerMXBean getStats();

    public void delete() throws InterruptedException, ManagedLedgerException;

    public void asyncDelete(AsyncCallbacks.DeleteLedgerCallback var1, Object var2);

    public Position offloadPrefix(Position var1) throws InterruptedException, ManagedLedgerException;

    public void asyncOffloadPrefix(Position var1, AsyncCallbacks.OffloadCallback var2, Object var3);

    public ManagedCursor getSlowestConsumer();

    public boolean isTerminated();

    public ManagedLedgerConfig getConfig();

    public void setConfig(ManagedLedgerConfig var1);

    public Position getLastConfirmedEntry();

    public void readyToCreateNewLedger();

    public Map<String, String> getProperties();

    public void setProperty(String var1, String var2) throws InterruptedException, ManagedLedgerException;

    public void asyncSetProperty(String var1, String var2, AsyncCallbacks.UpdatePropertiesCallback var3, Object var4);

    public void deleteProperty(String var1) throws InterruptedException, ManagedLedgerException;

    public void asyncDeleteProperty(String var1, AsyncCallbacks.UpdatePropertiesCallback var2, Object var3);

    public void setProperties(Map<String, String> var1) throws InterruptedException, ManagedLedgerException;

    public void asyncSetProperties(Map<String, String> var1, AsyncCallbacks.UpdatePropertiesCallback var2, Object var3);

    public void trimConsumedLedgersInBackground(CompletableFuture<?> var1);

    public void rollCurrentLedgerIfFull();
}

