/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import org.apache.pulsar.metadata.api.GetResult;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.Stat;
import org.apache.pulsar.shade.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.CompositeByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;
import org.apache.pulsar.shade.io.netty.util.ReferenceCounted;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.SafeRunnable;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.MetaStore;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.proto.MLDataFormats;
import org.apache.pulsar.shade.org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.shade.org.apache.pulsar.common.compression.CompressionCodec;
import org.apache.pulsar.shade.org.apache.pulsar.common.compression.CompressionCodecProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaStoreImpl
implements MetaStore {
    private static final Logger log = LoggerFactory.getLogger(MetaStoreImpl.class);
    private static final String BASE_NODE = "/managed-ledgers";
    private static final String PREFIX = "/managed-ledgers/";
    private final MetadataStore store;
    private final OrderedExecutor executor;
    private static final int MAGIC_MANAGED_LEDGER_INFO_METADATA = 18296;
    private final MLDataFormats.CompressionType compressionType;

    public MetaStoreImpl(MetadataStore store, OrderedExecutor executor) {
        this.store = store;
        this.executor = executor;
        this.compressionType = MLDataFormats.CompressionType.NONE;
    }

    public MetaStoreImpl(MetadataStore store, OrderedExecutor executor, String compressionType) {
        MLDataFormats.CompressionType finalCompressionType;
        this.store = store;
        this.executor = executor;
        if (compressionType != null) {
            try {
                finalCompressionType = MLDataFormats.CompressionType.valueOf(compressionType);
            }
            catch (Exception e) {
                log.error("Failed to get compression type {} error msg: {}.", (Object)compressionType, (Object)e.getMessage());
                throw e;
            }
        } else {
            finalCompressionType = MLDataFormats.CompressionType.NONE;
        }
        this.compressionType = finalCompressionType;
    }

    @Override
    public void getManagedLedgerInfo(String ledgerName, boolean createIfMissing, MetaStore.MetaStoreCallback<MLDataFormats.ManagedLedgerInfo> callback) {
        String path = PREFIX + ledgerName;
        ((CompletableFuture)this.store.get(path).thenAcceptAsync(optResult -> {
            if (optResult.isPresent()) {
                try {
                    MLDataFormats.ManagedLedgerInfo info = this.parseManagedLedgerInfo(((GetResult)optResult.get()).getValue());
                    info = MetaStoreImpl.updateMLInfoTimestamp(info);
                    callback.operationComplete(info, ((GetResult)optResult.get()).getStat());
                }
                catch (InvalidProtocolBufferException e) {
                    callback.operationFailed(MetaStoreImpl.getException(e));
                }
            } else if (createIfMissing) {
                log.info("Creating '{}'", (Object)path);
                ((CompletableFuture)this.store.put(path, new byte[0], Optional.of(-1L)).thenAccept(stat -> {
                    MLDataFormats.ManagedLedgerInfo info = MLDataFormats.ManagedLedgerInfo.getDefaultInstance();
                    callback.operationComplete(info, (Stat)stat);
                })).exceptionally(ex -> {
                    callback.operationFailed(MetaStoreImpl.getException(ex));
                    return null;
                });
            } else {
                callback.operationFailed(new ManagedLedgerException.MetadataNotFoundException("Managed ledger not found"));
            }
        }, (Executor)this.executor.chooseThread(ledgerName))).exceptionally(ex -> {
            this.executor.executeOrdered(ledgerName, (SafeRunnable)org.apache.pulsar.shade.org.apache.bookkeeper.util.SafeRunnable.safeRun(() -> callback.operationFailed(MetaStoreImpl.getException(ex))));
            return null;
        });
    }

    @Override
    public void asyncUpdateLedgerIds(String ledgerName, MLDataFormats.ManagedLedgerInfo mlInfo, Stat stat, MetaStore.MetaStoreCallback<Void> callback) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] Updating metadata version={} with content={}", new Object[]{ledgerName, stat, mlInfo});
        }
        String path = PREFIX + ledgerName;
        ((CompletableFuture)this.store.put(path, this.compressLedgerInfo(mlInfo), Optional.of(stat.getVersion())).thenAcceptAsync(newVersion -> callback.operationComplete((Void)null, (Stat)newVersion), (Executor)this.executor.chooseThread(ledgerName))).exceptionally(ex -> {
            this.executor.executeOrdered(ledgerName, (SafeRunnable)org.apache.pulsar.shade.org.apache.bookkeeper.util.SafeRunnable.safeRun(() -> callback.operationFailed(MetaStoreImpl.getException(ex))));
            return null;
        });
    }

    @Override
    public void getCursors(String ledgerName, MetaStore.MetaStoreCallback<List<String>> callback) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] Get cursors list", (Object)ledgerName);
        }
        String path = PREFIX + ledgerName;
        ((CompletableFuture)this.store.getChildren(path).thenAcceptAsync(cursors -> callback.operationComplete((List<String>)cursors, null), (Executor)this.executor.chooseThread(ledgerName))).exceptionally(ex -> {
            this.executor.executeOrdered(ledgerName, (SafeRunnable)org.apache.pulsar.shade.org.apache.bookkeeper.util.SafeRunnable.safeRun(() -> callback.operationFailed(MetaStoreImpl.getException(ex))));
            return null;
        });
    }

    @Override
    public void asyncGetCursorInfo(String ledgerName, String cursorName, MetaStore.MetaStoreCallback<MLDataFormats.ManagedCursorInfo> callback) {
        String path = PREFIX + ledgerName + "/" + cursorName;
        if (log.isDebugEnabled()) {
            log.debug("Reading from {}", (Object)path);
        }
        ((CompletableFuture)this.store.get(path).thenAcceptAsync(optRes -> {
            if (optRes.isPresent()) {
                try {
                    MLDataFormats.ManagedCursorInfo info = MLDataFormats.ManagedCursorInfo.parseFrom(((GetResult)optRes.get()).getValue());
                    callback.operationComplete(info, ((GetResult)optRes.get()).getStat());
                }
                catch (InvalidProtocolBufferException e) {
                    callback.operationFailed(MetaStoreImpl.getException(e));
                }
            } else {
                callback.operationFailed(new ManagedLedgerException.MetadataNotFoundException("Cursor metadata not found"));
            }
        }, (Executor)this.executor.chooseThread(ledgerName))).exceptionally(ex -> {
            this.executor.executeOrdered(ledgerName, (SafeRunnable)org.apache.pulsar.shade.org.apache.bookkeeper.util.SafeRunnable.safeRun(() -> callback.operationFailed(MetaStoreImpl.getException(ex))));
            return null;
        });
    }

    @Override
    public void asyncUpdateCursorInfo(String ledgerName, String cursorName, MLDataFormats.ManagedCursorInfo info, Stat stat, MetaStore.MetaStoreCallback<Void> callback) {
        long expectedVersion;
        log.info("[{}] [{}] Updating cursor info ledgerId={} mark-delete={}:{}", new Object[]{ledgerName, cursorName, info.getCursorsLedgerId(), info.getMarkDeleteLedgerId(), info.getMarkDeleteEntryId()});
        String path = PREFIX + ledgerName + "/" + cursorName;
        byte[] content = info.toByteArray();
        if (stat != null) {
            expectedVersion = stat.getVersion();
            if (log.isDebugEnabled()) {
                log.debug("[{}] Creating consumer {} on meta-data store with {}", new Object[]{ledgerName, cursorName, info});
            }
        } else {
            expectedVersion = -1L;
            if (log.isDebugEnabled()) {
                log.debug("[{}] Updating consumer {} on meta-data store with {}", new Object[]{ledgerName, cursorName, info});
            }
        }
        ((CompletableFuture)this.store.put(path, content, Optional.of(expectedVersion)).thenAcceptAsync(optStat -> callback.operationComplete((Void)null, (Stat)optStat), (Executor)this.executor.chooseThread(ledgerName))).exceptionally(ex -> {
            this.executor.executeOrdered(ledgerName, (SafeRunnable)org.apache.pulsar.shade.org.apache.bookkeeper.util.SafeRunnable.safeRun(() -> callback.operationFailed(MetaStoreImpl.getException(ex))));
            return null;
        });
    }

    @Override
    public void asyncRemoveCursor(String ledgerName, String cursorName, MetaStore.MetaStoreCallback<Void> callback) {
        String path = PREFIX + ledgerName + "/" + cursorName;
        log.info("[{}] Remove consumer={}", (Object)ledgerName, (Object)cursorName);
        ((CompletableFuture)this.store.delete(path, Optional.empty()).thenAcceptAsync(v -> {
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] cursor delete done", (Object)ledgerName, (Object)cursorName);
            }
            callback.operationComplete(null, null);
        }, (Executor)this.executor.chooseThread(ledgerName))).exceptionally(ex -> {
            this.executor.executeOrdered(ledgerName, (SafeRunnable)org.apache.pulsar.shade.org.apache.bookkeeper.util.SafeRunnable.safeRun(() -> callback.operationFailed(MetaStoreImpl.getException(ex))));
            return null;
        });
    }

    @Override
    public void removeManagedLedger(String ledgerName, MetaStore.MetaStoreCallback<Void> callback) {
        log.info("[{}] Remove ManagedLedger", (Object)ledgerName);
        String path = PREFIX + ledgerName;
        ((CompletableFuture)this.store.delete(path, Optional.empty()).thenAcceptAsync(v -> {
            if (log.isDebugEnabled()) {
                log.debug("[{}] managed ledger delete done", (Object)ledgerName);
            }
            callback.operationComplete(null, null);
        }, (Executor)this.executor.chooseThread(ledgerName))).exceptionally(ex -> {
            this.executor.executeOrdered(ledgerName, (SafeRunnable)org.apache.pulsar.shade.org.apache.bookkeeper.util.SafeRunnable.safeRun(() -> callback.operationFailed(MetaStoreImpl.getException(ex))));
            return null;
        });
    }

    @Override
    public Iterable<String> getManagedLedgers() throws ManagedLedgerException.MetaStoreException {
        try {
            return this.store.getChildren(BASE_NODE).join();
        }
        catch (CompletionException e) {
            throw MetaStoreImpl.getException(e);
        }
    }

    private static MLDataFormats.ManagedLedgerInfo updateMLInfoTimestamp(MLDataFormats.ManagedLedgerInfo info) {
        ArrayList<MLDataFormats.ManagedLedgerInfo.LedgerInfo> infoList = new ArrayList<MLDataFormats.ManagedLedgerInfo.LedgerInfo>(info.getLedgerInfoCount());
        long currentTime = System.currentTimeMillis();
        for (MLDataFormats.ManagedLedgerInfo.LedgerInfo ledgerInfo : info.getLedgerInfoList()) {
            if (!ledgerInfo.hasTimestamp() || ledgerInfo.getTimestamp() == 0L) {
                MLDataFormats.ManagedLedgerInfo.LedgerInfo.Builder singleInfoBuilder = ledgerInfo.toBuilder();
                singleInfoBuilder.setTimestamp(currentTime);
                infoList.add(singleInfoBuilder.build());
                continue;
            }
            infoList.add(ledgerInfo);
        }
        MLDataFormats.ManagedLedgerInfo.Builder mlInfo = MLDataFormats.ManagedLedgerInfo.newBuilder();
        mlInfo.addAllLedgerInfo(infoList);
        if (info.hasTerminatedPosition()) {
            mlInfo.setTerminatedPosition(info.getTerminatedPosition());
        }
        mlInfo.addAllProperties(info.getPropertiesList());
        return mlInfo.build();
    }

    private static ManagedLedgerException.MetaStoreException getException(Throwable t) {
        if (t.getCause() instanceof MetadataStoreException.BadVersionException) {
            return new ManagedLedgerException.BadVersionException(t.getMessage());
        }
        return new ManagedLedgerException.MetaStoreException(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] compressLedgerInfo(MLDataFormats.ManagedLedgerInfo managedLedgerInfo) {
        if (this.compressionType == null || this.compressionType.equals(MLDataFormats.CompressionType.NONE)) {
            return managedLedgerInfo.toByteArray();
        }
        ReferenceCounted metadataByteBuf = null;
        ReferenceCounted encodeByteBuf = null;
        try {
            MLDataFormats.ManagedLedgerInfoMetadata mlInfoMetadata = MLDataFormats.ManagedLedgerInfoMetadata.newBuilder().setCompressionType(this.compressionType).setUncompressedSize(managedLedgerInfo.getSerializedSize()).build();
            metadataByteBuf = PulsarByteBufAllocator.DEFAULT.buffer(mlInfoMetadata.getSerializedSize() + 6, mlInfoMetadata.getSerializedSize() + 6);
            ((ByteBuf)metadataByteBuf).writeShort(18296);
            ((ByteBuf)metadataByteBuf).writeInt(mlInfoMetadata.getSerializedSize());
            ((ByteBuf)metadataByteBuf).writeBytes(mlInfoMetadata.toByteArray());
            encodeByteBuf = this.getCompressionCodec(this.compressionType).encode(Unpooled.wrappedBuffer(managedLedgerInfo.toByteArray()));
            CompositeByteBuf compositeByteBuf = PulsarByteBufAllocator.DEFAULT.compositeBuffer();
            compositeByteBuf.addComponent(true, (ByteBuf)metadataByteBuf);
            compositeByteBuf.addComponent(true, (ByteBuf)encodeByteBuf);
            byte[] dataBytes = new byte[compositeByteBuf.readableBytes()];
            compositeByteBuf.readBytes(dataBytes);
            byte[] byArray = dataBytes;
            return byArray;
        }
        finally {
            if (metadataByteBuf != null) {
                metadataByteBuf.release();
            }
            if (encodeByteBuf != null) {
                encodeByteBuf.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MLDataFormats.ManagedLedgerInfo parseManagedLedgerInfo(byte[] data) throws InvalidProtocolBufferException {
        ByteBuf byteBuf = Unpooled.wrappedBuffer(data);
        if (byteBuf.readableBytes() > 0 && byteBuf.readShort() == 18296) {
            ReferenceCounted decodeByteBuf = null;
            try {
                byte[] decodeBytes;
                int metadataSize = byteBuf.readInt();
                byte[] metadataBytes = new byte[metadataSize];
                byteBuf.readBytes(metadataBytes);
                MLDataFormats.ManagedLedgerInfoMetadata metadata = MLDataFormats.ManagedLedgerInfoMetadata.parseFrom(metadataBytes);
                long unpressedSize = metadata.getUncompressedSize();
                decodeByteBuf = this.getCompressionCodec(metadata.getCompressionType()).decode(byteBuf, (int)unpressedSize);
                if (((ByteBuf)decodeByteBuf).hasArray() && !MLDataFormats.CompressionType.ZLIB.equals(metadata.getCompressionType())) {
                    decodeBytes = ((ByteBuf)decodeByteBuf).array();
                } else {
                    decodeBytes = new byte[((ByteBuf)decodeByteBuf).readableBytes() - ((ByteBuf)decodeByteBuf).readerIndex()];
                    ((ByteBuf)decodeByteBuf).readBytes(decodeBytes);
                }
                MLDataFormats.ManagedLedgerInfo managedLedgerInfo = MLDataFormats.ManagedLedgerInfo.parseFrom(decodeBytes);
                return managedLedgerInfo;
            }
            catch (Exception e) {
                log.error("Failed to parse managedLedgerInfo metadata, fall back to parse managedLedgerInfo directly.", (Throwable)e);
                MLDataFormats.ManagedLedgerInfo managedLedgerInfo = MLDataFormats.ManagedLedgerInfo.parseFrom(data);
                return managedLedgerInfo;
            }
            finally {
                if (decodeByteBuf != null) {
                    decodeByteBuf.release();
                }
            }
        }
        return MLDataFormats.ManagedLedgerInfo.parseFrom(data);
    }

    private CompressionCodec getCompressionCodec(MLDataFormats.CompressionType compressionType) {
        return CompressionCodecProvider.getCompressionCodec(PulsarApi.CompressionType.valueOf(compressionType.name()));
    }
}

