/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.statelib.api;

import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.coder.Coder;
import org.apache.pulsar.shade.org.apache.bookkeeper.statelib.api.checkpoint.CheckpointStore;

public class StateStoreSpec {
    private String name;
    private Coder<?> keyCoder;
    private Coder<?> valCoder;
    private File localStateStoreDir;
    private String stream;
    private boolean isReadonly;
    private ScheduledExecutorService writeIOScheduler;
    private ScheduledExecutorService readIOScheduler;
    private ScheduledExecutorService checkpointIOScheduler;
    private CheckpointStore checkpointStore;
    private Duration checkpointDuration;
    private Map<String, Object> configs;

    private static Duration $default$checkpointDuration() {
        return Duration.ofMinutes(1L);
    }

    StateStoreSpec(String name, Coder<?> keyCoder, Coder<?> valCoder, File localStateStoreDir, String stream, boolean isReadonly, ScheduledExecutorService writeIOScheduler, ScheduledExecutorService readIOScheduler, ScheduledExecutorService checkpointIOScheduler, CheckpointStore checkpointStore, Duration checkpointDuration, Map<String, Object> configs) {
        this.name = name;
        this.keyCoder = keyCoder;
        this.valCoder = valCoder;
        this.localStateStoreDir = localStateStoreDir;
        this.stream = stream;
        this.isReadonly = isReadonly;
        this.writeIOScheduler = writeIOScheduler;
        this.readIOScheduler = readIOScheduler;
        this.checkpointIOScheduler = checkpointIOScheduler;
        this.checkpointStore = checkpointStore;
        this.checkpointDuration = checkpointDuration;
        this.configs = configs;
    }

    public static StateStoreSpecBuilder builder() {
        return new StateStoreSpecBuilder();
    }

    public String getName() {
        return this.name;
    }

    public Coder<?> getKeyCoder() {
        return this.keyCoder;
    }

    public Coder<?> getValCoder() {
        return this.valCoder;
    }

    public File getLocalStateStoreDir() {
        return this.localStateStoreDir;
    }

    public String getStream() {
        return this.stream;
    }

    public boolean isReadonly() {
        return this.isReadonly;
    }

    public ScheduledExecutorService getWriteIOScheduler() {
        return this.writeIOScheduler;
    }

    public ScheduledExecutorService getReadIOScheduler() {
        return this.readIOScheduler;
    }

    public ScheduledExecutorService getCheckpointIOScheduler() {
        return this.checkpointIOScheduler;
    }

    public CheckpointStore getCheckpointStore() {
        return this.checkpointStore;
    }

    public Duration getCheckpointDuration() {
        return this.checkpointDuration;
    }

    public Map<String, Object> getConfigs() {
        return this.configs;
    }

    public static class StateStoreSpecBuilder {
        private String name;
        private Coder<?> keyCoder;
        private Coder<?> valCoder;
        private File localStateStoreDir;
        private String stream;
        private boolean isReadonly;
        private ScheduledExecutorService writeIOScheduler;
        private ScheduledExecutorService readIOScheduler;
        private ScheduledExecutorService checkpointIOScheduler;
        private CheckpointStore checkpointStore;
        private boolean checkpointDuration$set;
        private Duration checkpointDuration$value;
        private ArrayList<String> configs$key;
        private ArrayList<Object> configs$value;

        StateStoreSpecBuilder() {
        }

        public StateStoreSpecBuilder name(String name) {
            this.name = name;
            return this;
        }

        public StateStoreSpecBuilder keyCoder(Coder<?> keyCoder) {
            this.keyCoder = keyCoder;
            return this;
        }

        public StateStoreSpecBuilder valCoder(Coder<?> valCoder) {
            this.valCoder = valCoder;
            return this;
        }

        public StateStoreSpecBuilder localStateStoreDir(File localStateStoreDir) {
            this.localStateStoreDir = localStateStoreDir;
            return this;
        }

        public StateStoreSpecBuilder stream(String stream) {
            this.stream = stream;
            return this;
        }

        public StateStoreSpecBuilder isReadonly(boolean isReadonly) {
            this.isReadonly = isReadonly;
            return this;
        }

        public StateStoreSpecBuilder writeIOScheduler(ScheduledExecutorService writeIOScheduler) {
            this.writeIOScheduler = writeIOScheduler;
            return this;
        }

        public StateStoreSpecBuilder readIOScheduler(ScheduledExecutorService readIOScheduler) {
            this.readIOScheduler = readIOScheduler;
            return this;
        }

        public StateStoreSpecBuilder checkpointIOScheduler(ScheduledExecutorService checkpointIOScheduler) {
            this.checkpointIOScheduler = checkpointIOScheduler;
            return this;
        }

        public StateStoreSpecBuilder checkpointStore(CheckpointStore checkpointStore) {
            this.checkpointStore = checkpointStore;
            return this;
        }

        public StateStoreSpecBuilder checkpointDuration(Duration checkpointDuration) {
            this.checkpointDuration$value = checkpointDuration;
            this.checkpointDuration$set = true;
            return this;
        }

        public StateStoreSpecBuilder config(String configKey, Object configValue) {
            if (this.configs$key == null) {
                this.configs$key = new ArrayList();
                this.configs$value = new ArrayList();
            }
            this.configs$key.add(configKey);
            this.configs$value.add(configValue);
            return this;
        }

        public StateStoreSpecBuilder configs(Map<? extends String, ? extends Object> configs) {
            if (this.configs$key == null) {
                this.configs$key = new ArrayList();
                this.configs$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : configs.entrySet()) {
                this.configs$key.add($lombokEntry.getKey());
                this.configs$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public StateStoreSpecBuilder clearConfigs() {
            if (this.configs$key != null) {
                this.configs$key.clear();
                this.configs$value.clear();
            }
            return this;
        }

        public StateStoreSpec build() {
            Map<Object, Object> configs;
            switch (this.configs$key == null ? 0 : this.configs$key.size()) {
                case 0: {
                    configs = Collections.emptyMap();
                    break;
                }
                case 1: {
                    configs = Collections.singletonMap(this.configs$key.get(0), this.configs$value.get(0));
                    break;
                }
                default: {
                    configs = new LinkedHashMap(this.configs$key.size() < 0x40000000 ? 1 + this.configs$key.size() + (this.configs$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.configs$key.size(); ++$i) {
                        configs.put(this.configs$key.get($i), this.configs$value.get($i));
                    }
                    configs = Collections.unmodifiableMap(configs);
                }
            }
            Duration checkpointDuration$value = this.checkpointDuration$value;
            if (!this.checkpointDuration$set) {
                checkpointDuration$value = StateStoreSpec.$default$checkpointDuration();
            }
            return new StateStoreSpec(this.name, this.keyCoder, this.valCoder, this.localStateStoreDir, this.stream, this.isReadonly, this.writeIOScheduler, this.readIOScheduler, this.checkpointIOScheduler, this.checkpointStore, checkpointDuration$value, configs);
        }

        public String toString() {
            return "StateStoreSpec.StateStoreSpecBuilder(name=" + this.name + ", keyCoder=" + this.keyCoder + ", valCoder=" + this.valCoder + ", localStateStoreDir=" + this.localStateStoreDir + ", stream=" + this.stream + ", isReadonly=" + this.isReadonly + ", writeIOScheduler=" + this.writeIOScheduler + ", readIOScheduler=" + this.readIOScheduler + ", checkpointIOScheduler=" + this.checkpointIOScheduler + ", checkpointStore=" + this.checkpointStore + ", checkpointDuration$value=" + this.checkpointDuration$value + ", configs$key=" + this.configs$key + ", configs$value=" + this.configs$value + ")";
        }
    }
}

