/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.stats.prometheus;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.StampedLock;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.DoublesSketch;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.DoublesSketchBuilder;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.DoublesUnion;
import org.apache.pulsar.shade.com.yahoo.sketches.quantiles.DoublesUnionBuilder;
import org.apache.pulsar.shade.io.netty.util.concurrent.FastThreadLocal;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.OpStatsData;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.OpStatsLogger;

public class DataSketchesOpStatsLogger
implements OpStatsLogger {
    private volatile ThreadLocalAccessor current;
    private volatile ThreadLocalAccessor replacement;
    private volatile DoublesSketch successResult;
    private volatile DoublesSketch failResult;
    private final LongAdder successCountAdder = new LongAdder();
    private final LongAdder failCountAdder = new LongAdder();
    private final LongAdder successSumAdder = new LongAdder();
    private final LongAdder failSumAdder = new LongAdder();

    DataSketchesOpStatsLogger() {
        this.current = new ThreadLocalAccessor();
        this.replacement = new ThreadLocalAccessor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerFailedEvent(long eventLatency, TimeUnit unit) {
        double valueMillis = (double)unit.toMicros(eventLatency) / 1000.0;
        this.failCountAdder.increment();
        this.failSumAdder.add((long)valueMillis);
        LocalData localData = (LocalData)this.current.localData.get();
        long stamp = localData.lock.readLock();
        try {
            localData.failSketch.update(valueMillis);
        }
        finally {
            localData.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerSuccessfulEvent(long eventLatency, TimeUnit unit) {
        double valueMillis = (double)unit.toMicros(eventLatency) / 1000.0;
        this.successCountAdder.increment();
        this.successSumAdder.add((long)valueMillis);
        LocalData localData = (LocalData)this.current.localData.get();
        long stamp = localData.lock.readLock();
        try {
            localData.successSketch.update(valueMillis);
        }
        finally {
            localData.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerSuccessfulValue(long value) {
        this.successCountAdder.increment();
        this.successSumAdder.add(value);
        LocalData localData = (LocalData)this.current.localData.get();
        long stamp = localData.lock.readLock();
        try {
            localData.successSketch.update(value);
        }
        finally {
            localData.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerFailedValue(long value) {
        this.failCountAdder.increment();
        this.failSumAdder.add(value);
        LocalData localData = (LocalData)this.current.localData.get();
        long stamp = localData.lock.readLock();
        try {
            localData.failSketch.update(value);
        }
        finally {
            localData.lock.unlockRead(stamp);
        }
    }

    @Override
    public OpStatsData toOpStatsData() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public void rotateLatencyCollection() {
        ThreadLocalAccessor local = this.current;
        this.current = this.replacement;
        this.replacement = local;
        DoublesUnion aggregateSuccesss = new DoublesUnionBuilder().build();
        DoublesUnion aggregateFail = new DoublesUnionBuilder().build();
        local.map.forEach((localData, b) -> {
            long stamp = ((LocalData)localData).lock.writeLock();
            try {
                aggregateSuccesss.update(((LocalData)localData).successSketch);
                ((LocalData)localData).successSketch.reset();
                aggregateFail.update(((LocalData)localData).failSketch);
                ((LocalData)localData).failSketch.reset();
            }
            finally {
                ((LocalData)localData).lock.unlockWrite(stamp);
            }
        });
        this.successResult = aggregateSuccesss.getResultAndReset();
        this.failResult = aggregateFail.getResultAndReset();
    }

    public long getCount(boolean success) {
        return success ? this.successCountAdder.sum() : this.failCountAdder.sum();
    }

    public long getSum(boolean success) {
        return success ? this.successSumAdder.sum() : this.failSumAdder.sum();
    }

    public double getQuantileValue(boolean success, double quantile) {
        DoublesSketch s = success ? this.successResult : this.failResult;
        return s != null ? s.getQuantile(quantile) : Double.NaN;
    }

    private static class ThreadLocalAccessor {
        private final Map<LocalData, Boolean> map = new ConcurrentHashMap<LocalData, Boolean>();
        private final FastThreadLocal<LocalData> localData = new FastThreadLocal<LocalData>(){

            @Override
            protected LocalData initialValue() throws Exception {
                LocalData localData = new LocalData();
                map.put(localData, Boolean.TRUE);
                return localData;
            }

            @Override
            protected void onRemoval(LocalData value) throws Exception {
                map.remove(value);
            }
        };

        private ThreadLocalAccessor() {
        }
    }

    private static class LocalData {
        private final DoublesSketch successSketch = new DoublesSketchBuilder().build();
        private final DoublesSketch failSketch = new DoublesSketchBuilder().build();
        private final StampedLock lock = new StampedLock();

        private LocalData() {
        }
    }
}

