/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.tools.cli.commands.autorecovery;

import java.io.IOException;
import java.net.URI;
import org.apache.pulsar.shade.com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.BookieId;
import org.apache.pulsar.shade.org.apache.bookkeeper.replication.AuditorElector;
import org.apache.pulsar.shade.org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import org.apache.pulsar.shade.org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.pulsar.shade.org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.pulsar.shade.org.apache.bookkeeper.zookeeper.ZooKeeperClient;
import org.apache.pulsar.shade.org.apache.commons.configuration.ConfigurationException;
import org.apache.pulsar.shade.org.apache.zookeeper.KeeperException;
import org.apache.pulsar.shade.org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhoIsAuditorCommand
extends BookieCommand<CliFlags> {
    static final Logger LOG = LoggerFactory.getLogger(WhoIsAuditorCommand.class);
    private static final String NAME = "whoisauditor";
    private static final String DESC = "Print the node which holds the auditor lock.";

    public WhoIsAuditorCommand() {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags(new CliFlags()).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, CliFlags cmdFlags) {
        try {
            return this.getAuditor(conf);
        }
        catch (Exception e) {
            throw new UncheckedExecutionException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAuditor(ServerConfiguration conf) throws ConfigurationException, InterruptedException, IOException, KeeperException {
        try (ZooKeeper zk = null;){
            String metadataServiceUri = conf.getMetadataServiceUri();
            String zkServers = ZKMetadataDriverBase.getZKServersFromServiceUri(URI.create(metadataServiceUri));
            zk = ZooKeeperClient.newBuilder().connectString(zkServers).sessionTimeoutMs(conf.getZkTimeout()).build();
            BookieId bookieId = AuditorElector.getCurrentAuditor(conf, zk);
            if (bookieId == null) {
                LOG.info("No auditor elected");
                boolean bl = false;
                return bl;
            }
            LOG.info("Auditor: " + bookieId);
        }
        return true;
    }
}

