/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.tools.cli.helpers;

import java.net.InetAddress;
import org.apache.pulsar.shade.com.google.common.net.InetAddresses;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.BookieId;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.BookieAddressResolver;

public final class CommandHelpers {
    private static final String UNKNOWN = "UNKNOWN";

    public static String getBookieSocketAddrStringRepresentation(BookieId bookieId, BookieAddressResolver bookieAddressResolver) {
        String realHostname;
        String ip;
        BookieSocketAddress networkAddress = bookieAddressResolver.resolve(bookieId);
        String hostname = networkAddress.getHostName();
        if (InetAddresses.isInetAddress(hostname)) {
            ip = hostname;
            realHostname = networkAddress.getSocketAddress().getAddress().getCanonicalHostName();
        } else {
            InetAddress ia = networkAddress.getSocketAddress().getAddress();
            ip = null != ia ? ia.getHostAddress() : UNKNOWN;
            realHostname = hostname;
        }
        return CommandHelpers.formatBookieSocketAddress(bookieId, ip, networkAddress.getPort(), realHostname);
    }

    private static String formatBookieSocketAddress(BookieId bookieId, String ip, int port, String hostName) {
        return String.format("BookieID:%s, IP:%s, Port:%d, Hostname:%s", bookieId.toString(), ip, port, hostName);
    }

    private CommandHelpers() {
    }
}

