/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.util;

import java.util.concurrent.ThreadFactory;
import org.apache.pulsar.shade.io.netty.channel.EventLoopGroup;
import org.apache.pulsar.shade.io.netty.channel.epoll.EpollEventLoopGroup;
import org.apache.pulsar.shade.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.affinity.CpuAffinity;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.shade.org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventLoopUtil {
    private static final Logger log = LoggerFactory.getLogger(EventLoopUtil.class);

    public static EventLoopGroup getClientEventLoopGroup(ClientConfiguration conf, ThreadFactory threadFactory) {
        return EventLoopUtil.getEventLoopGroup(threadFactory, conf.getNumIOThreads(), conf.isBusyWaitEnabled());
    }

    public static EventLoopGroup getServerEventLoopGroup(ServerConfiguration conf, ThreadFactory threadFactory) {
        return EventLoopUtil.getEventLoopGroup(threadFactory, conf.getServerNumIOThreads(), conf.isBusyWaitEnabled());
    }

    private static EventLoopGroup getEventLoopGroup(ThreadFactory threadFactory, int numThreads, boolean enableBusyWait) {
        if (!SystemUtils.IS_OS_LINUX) {
            return new NioEventLoopGroup(numThreads, threadFactory);
        }
        try {
            if (!enableBusyWait) {
                return new EpollEventLoopGroup(numThreads, threadFactory);
            }
            EpollEventLoopGroup eventLoopGroup = new EpollEventLoopGroup(numThreads, threadFactory, () -> (selectSupplier, hasTasks) -> -3);
            for (int i = 0; i < numThreads; ++i) {
                eventLoopGroup.next().submit(() -> {
                    try {
                        CpuAffinity.acquireCore();
                    }
                    catch (Throwable t) {
                        log.warn("Failed to acquire CPU core for thread {}", new Object[]{Thread.currentThread().getName(), t.getMessage(), t});
                    }
                });
            }
            return eventLoopGroup;
        }
        catch (ExceptionInInitializerError | NoClassDefFoundError | UnsatisfiedLinkError e) {
            log.warn("Could not use Netty Epoll event loop: {}", (Object)e.getMessage());
            return new NioEventLoopGroup(numThreads, threadFactory);
        }
    }

    private EventLoopUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

