/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.protocol;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.PulsarApi;

public final class CommandUtils {
    private CommandUtils() {
    }

    public static Map<String, String> metadataFromCommand(PulsarApi.CommandProducer commandProducer) {
        return CommandUtils.toMap(commandProducer.getMetadataList());
    }

    public static Map<String, String> metadataFromCommand(PulsarApi.CommandSubscribe commandSubscribe) {
        return CommandUtils.toMap(commandSubscribe.getMetadataList());
    }

    static List<PulsarApi.KeyValue> toKeyValueList(Map<String, String> metadata) {
        if (metadata == null || metadata.isEmpty()) {
            return Collections.emptyList();
        }
        return metadata.entrySet().stream().map(e -> PulsarApi.KeyValue.newBuilder().setKey((String)e.getKey()).setValue((String)e.getValue()).build()).collect(Collectors.toList());
    }

    private static Map<String, String> toMap(List<PulsarApi.KeyValue> keyValues) {
        if (keyValues == null || keyValues.isEmpty()) {
            return Collections.emptyMap();
        }
        return keyValues.stream().collect(Collectors.toMap(PulsarApi.KeyValue::getKey, PulsarApi.KeyValue::getValue));
    }
}

