/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.util;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.pulsar.shade.com.google.common.base.MoreObjects;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.RateLimitFunction;

public class RateLimiter
implements AutoCloseable {
    private final ScheduledExecutorService executorService;
    private long rateTime;
    private TimeUnit timeUnit;
    private final boolean externalExecutor;
    private ScheduledFuture<?> renewTask;
    private long permits;
    private long acquiredPermits;
    private boolean isClosed;
    private Supplier<Long> permitUpdater;
    private RateLimitFunction rateLimitFunction;

    public RateLimiter(long permits, long rateTime, TimeUnit timeUnit) {
        this(null, permits, rateTime, timeUnit, null);
    }

    public RateLimiter(long permits, long rateTime, TimeUnit timeUnit, RateLimitFunction autoReadResetFunction) {
        this(null, permits, rateTime, timeUnit, null);
        this.rateLimitFunction = autoReadResetFunction;
    }

    public RateLimiter(ScheduledExecutorService service, long permits, long rateTime, TimeUnit timeUnit, Supplier<Long> permitUpdater) {
        Preconditions.checkArgument(permits > 0L, "rate must be > 0");
        Preconditions.checkArgument(rateTime > 0L, "Renew permit time must be > 0");
        this.rateTime = rateTime;
        this.timeUnit = timeUnit;
        this.permits = permits;
        this.permitUpdater = permitUpdater;
        if (service != null) {
            this.executorService = service;
            this.externalExecutor = true;
        } else {
            ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
            executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
            executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            this.executorService = executor;
            this.externalExecutor = false;
        }
    }

    @Override
    public synchronized void close() {
        if (!this.isClosed) {
            if (!this.externalExecutor) {
                this.executorService.shutdownNow();
            }
            if (this.renewTask != null) {
                this.renewTask.cancel(false);
            }
            this.isClosed = true;
        }
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    public synchronized void acquire() throws InterruptedException {
        this.acquire(1L);
    }

    public synchronized void acquire(long acquirePermit) throws InterruptedException {
        Preconditions.checkArgument(!this.isClosed(), "Rate limiter is already shutdown");
        Preconditions.checkArgument(acquirePermit <= this.permits, "acquiring permits must be less or equal than initialized rate =" + this.permits);
        if (this.renewTask == null) {
            this.renewTask = this.createTask();
        }
        boolean canAcquire = false;
        do {
            boolean bl = canAcquire = acquirePermit < 0L || this.acquiredPermits < this.permits;
            if (!canAcquire) {
                this.wait();
                continue;
            }
            this.acquiredPermits += acquirePermit;
        } while (!canAcquire);
    }

    public synchronized boolean tryAcquire() {
        return this.tryAcquire(1L);
    }

    public synchronized boolean tryAcquire(long acquirePermit) {
        boolean canAcquire;
        Preconditions.checkArgument(!this.isClosed(), "Rate limiter is already shutdown");
        if (this.renewTask == null) {
            this.renewTask = this.createTask();
        }
        if (acquirePermit > this.permits) {
            this.acquiredPermits = this.permits;
            return false;
        }
        boolean bl = canAcquire = acquirePermit < 0L || this.acquiredPermits < this.permits;
        if (canAcquire) {
            this.acquiredPermits += acquirePermit;
        }
        return canAcquire;
    }

    public synchronized long getAvailablePermits() {
        return Math.max(0L, this.permits - this.acquiredPermits);
    }

    public synchronized void setRate(long permits) {
        this.permits = permits;
    }

    public synchronized void setRate(long permits, long rateTime, TimeUnit timeUnit, Supplier<Long> permitUpdaterByte) {
        if (this.renewTask != null) {
            this.renewTask.cancel(false);
        }
        this.permits = permits;
        this.rateTime = rateTime;
        this.timeUnit = timeUnit;
        this.permitUpdater = permitUpdaterByte;
        this.renewTask = this.createTask();
    }

    public synchronized long getRate() {
        return this.permits;
    }

    public synchronized long getRateTime() {
        return this.rateTime;
    }

    public synchronized TimeUnit getRateTimeUnit() {
        return this.timeUnit;
    }

    protected ScheduledFuture<?> createTask() {
        return this.executorService.scheduleAtFixedRate(this::renew, this.rateTime, this.rateTime, this.timeUnit);
    }

    synchronized void renew() {
        long newPermitRate;
        this.acquiredPermits = 0L;
        if (this.permitUpdater != null && (newPermitRate = this.permitUpdater.get().longValue()) > 0L) {
            this.setRate(newPermitRate);
        }
        if (this.rateLimitFunction != null) {
            this.rateLimitFunction.apply();
        }
        this.notifyAll();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("rateTime", this.rateTime).add("permits", this.permits).add("acquiredPermits", this.acquiredPermits).toString();
    }
}

