/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.util.protobuf;

import java.io.IOException;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.util.Recycler;
import org.apache.pulsar.shade.io.netty.util.concurrent.FastThreadLocal;
import org.apache.pulsar.shaded.com.google.protobuf.v241.ByteString;

public class ByteBufCodedOutputStream {
    private ByteBuf buf;
    private final Recycler.Handle<ByteBufCodedOutputStream> recyclerHandle;
    private static final Recycler<ByteBufCodedOutputStream> RECYCLER = new Recycler<ByteBufCodedOutputStream>(){

        @Override
        protected ByteBufCodedOutputStream newObject(Recycler.Handle<ByteBufCodedOutputStream> handle) {
            return new ByteBufCodedOutputStream(handle);
        }
    };
    private static final FastThreadLocal<byte[]> localByteArray = new FastThreadLocal();
    static final int TAG_TYPE_BITS = 3;

    public static ByteBufCodedOutputStream get(ByteBuf buf) {
        ByteBufCodedOutputStream stream = RECYCLER.get();
        stream.buf = buf;
        return stream;
    }

    public void recycle() {
        this.buf = null;
        this.recyclerHandle.recycle(this);
    }

    private ByteBufCodedOutputStream(Recycler.Handle<ByteBufCodedOutputStream> handle) {
        this.recyclerHandle = handle;
    }

    public void writeRawByte(int value) {
        this.buf.writeByte(value);
    }

    public void writeRawVarint32(int value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                this.writeRawByte(value);
                return;
            }
            this.writeRawByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    public void writeTag(int fieldNumber, int wireType) throws IOException {
        this.writeRawVarint32(ByteBufCodedOutputStream.makeTag(fieldNumber, wireType));
    }

    public void writeInt32(int fieldNumber, int value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeInt32NoTag(value);
    }

    public void writeInt64(int fieldNumber, long value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeInt64NoTag(value);
    }

    public void writeUInt64(int fieldNumber, long value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeUInt64NoTag(value);
    }

    public void writeBool(int fieldNumber, boolean value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeBoolNoTag(value);
    }

    public void writeBoolNoTag(boolean value) throws IOException {
        this.writeRawByte(value ? 1 : 0);
    }

    public void writeInt64NoTag(long value) throws IOException {
        this.writeRawVarint64(value);
    }

    public void writeUInt64NoTag(long value) throws IOException {
        this.writeRawVarint64(value);
    }

    public void writeRawVarint64(long value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.writeRawByte((int)value);
                return;
            }
            this.writeRawByte((int)value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    public void writeBytes(int fieldNumber, ByteString value) throws IOException {
        this.writeTag(fieldNumber, 2);
        this.writeBytesNoTag(value);
    }

    public void writeBytesNoTag(ByteString value) throws IOException {
        this.writeRawVarint32(value.size());
        this.writeRawBytes(value);
    }

    public void writeRawBytes(ByteString value) throws IOException {
        byte[] localBuf = localByteArray.get();
        if (localBuf == null || localBuf.length < value.size()) {
            localBuf = new byte[Math.max(value.size(), 1024)];
            localByteArray.set(localBuf);
        }
        value.copyTo(localBuf, 0);
        this.buf.writeBytes(localBuf, 0, value.size());
    }

    public void writeEnum(int fieldNumber, int value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeEnumNoTag(value);
    }

    public void writeUInt32(int fieldNumber, int value) throws IOException {
        this.writeTag(fieldNumber, 0);
        this.writeUInt32NoTag(value);
    }

    public void writeUInt32NoTag(int value) throws IOException {
        this.writeRawVarint32(value);
    }

    public void writeSFixed64(int fieldNumber, long value) throws IOException {
        this.writeTag(fieldNumber, 1);
        this.writeSFixed64NoTag(value);
    }

    public void writeSFixed64NoTag(long value) throws IOException {
        this.buf.writeLongLE(value);
    }

    public void writeEnumNoTag(int value) throws IOException {
        this.writeInt32NoTag(value);
    }

    public void writeInt32NoTag(int value) throws IOException {
        if (value >= 0) {
            this.writeRawVarint32(value);
        } else {
            this.writeRawVarint64(value);
        }
    }

    public void writeMessage(int fieldNumber, ByteBufGeneratedMessage value) throws IOException {
        this.writeTag(fieldNumber, 2);
        this.writeMessageNoTag(value);
    }

    public void writeMessageNoTag(ByteBufGeneratedMessage value) throws IOException {
        this.writeRawVarint32(value.getSerializedSize());
        value.writeTo(this);
    }

    static int makeTag(int fieldNumber, int wireType) {
        return fieldNumber << 3 | wireType;
    }

    public void writeDouble(int fieldNumber, double value) throws IOException {
        this.writeTag(fieldNumber, 1);
        this.buf.writeLongLE(Double.doubleToLongBits(value));
    }

    public static interface ByteBufGeneratedMessage {
        public int getSerializedSize();

        public void writeTo(ByteBufCodedOutputStream var1) throws IOException;
    }
}

