/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.zookeeper.server;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.Arrays;
import org.apache.pulsar.shade.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class ServerConfig {
    protected InetSocketAddress clientPortAddress;
    protected InetSocketAddress secureClientPortAddress;
    protected File dataDir;
    protected File dataLogDir;
    protected int tickTime = 3000;
    protected int maxClientCnxns;
    protected int minSessionTimeout = -1;
    protected int maxSessionTimeout = -1;

    public void parse(String[] args) {
        if (args.length < 2 || args.length > 4) {
            throw new IllegalArgumentException("Invalid number of arguments:" + Arrays.toString(args));
        }
        this.clientPortAddress = new InetSocketAddress(Integer.parseInt(args[0]));
        this.dataLogDir = this.dataDir = new File(args[1]);
        if (args.length >= 3) {
            this.tickTime = Integer.parseInt(args[2]);
        }
        if (args.length == 4) {
            this.maxClientCnxns = Integer.parseInt(args[3]);
        }
    }

    public void parse(String path) throws QuorumPeerConfig.ConfigException {
        QuorumPeerConfig config = new QuorumPeerConfig();
        config.parse(path);
        this.readFrom(config);
    }

    public void readFrom(QuorumPeerConfig config) {
        this.clientPortAddress = config.getClientPortAddress();
        this.secureClientPortAddress = config.getSecureClientPortAddress();
        this.dataDir = config.getDataDir();
        this.dataLogDir = config.getDataLogDir();
        this.tickTime = config.getTickTime();
        this.maxClientCnxns = config.getMaxClientCnxns();
        this.minSessionTimeout = config.getMinSessionTimeout();
        this.maxSessionTimeout = config.getMaxSessionTimeout();
    }

    public InetSocketAddress getClientPortAddress() {
        return this.clientPortAddress;
    }

    public InetSocketAddress getSecureClientPortAddress() {
        return this.secureClientPortAddress;
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public File getDataLogDir() {
        return this.dataLogDir;
    }

    public int getTickTime() {
        return this.tickTime;
    }

    public int getMaxClientCnxns() {
        return this.maxClientCnxns;
    }

    public int getMinSessionTimeout() {
        return this.minSessionTimeout;
    }

    public int getMaxSessionTimeout() {
        return this.maxSessionTimeout;
    }
}

