/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.zookeeper.server.quorum;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pulsar.shade.org.apache.zookeeper.KeeperException;
import org.apache.pulsar.shade.org.apache.zookeeper.server.SessionTracker;
import org.apache.pulsar.shade.org.apache.zookeeper.server.SessionTrackerImpl;
import org.apache.pulsar.shade.org.apache.zookeeper.server.ZooKeeperServerListener;
import org.apache.pulsar.shade.org.apache.zookeeper.server.quorum.UpgradeableSessionTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LearnerSessionTracker
extends UpgradeableSessionTracker {
    private static final Logger LOG = LoggerFactory.getLogger(LearnerSessionTracker.class);
    private final SessionTracker.SessionExpirer expirer;
    private final AtomicReference<Map<Long, Integer>> touchTable = new AtomicReference();
    private final long serverId;
    private final AtomicLong nextSessionId = new AtomicLong();
    private final boolean localSessionsEnabled;
    private final ConcurrentMap<Long, Integer> globalSessionsWithTimeouts;

    public LearnerSessionTracker(SessionTracker.SessionExpirer expirer, ConcurrentMap<Long, Integer> sessionsWithTimeouts, int tickTime, long id, boolean localSessionsEnabled, ZooKeeperServerListener listener) {
        this.expirer = expirer;
        this.touchTable.set(new ConcurrentHashMap());
        this.globalSessionsWithTimeouts = sessionsWithTimeouts;
        this.serverId = id;
        this.nextSessionId.set(SessionTrackerImpl.initializeNextSession(this.serverId));
        this.localSessionsEnabled = localSessionsEnabled;
        if (this.localSessionsEnabled) {
            this.createLocalSessionTracker(expirer, tickTime, id, listener);
        }
    }

    @Override
    public void removeSession(long sessionId) {
        if (this.localSessionTracker != null) {
            this.localSessionTracker.removeSession(sessionId);
        }
        this.globalSessionsWithTimeouts.remove(sessionId);
        this.touchTable.get().remove(sessionId);
    }

    @Override
    public void start() {
        if (this.localSessionTracker != null) {
            this.localSessionTracker.start();
        }
    }

    @Override
    public void shutdown() {
        if (this.localSessionTracker != null) {
            this.localSessionTracker.shutdown();
        }
    }

    @Override
    public boolean isGlobalSession(long sessionId) {
        return this.globalSessionsWithTimeouts.containsKey(sessionId);
    }

    @Override
    public boolean addGlobalSession(long sessionId, int sessionTimeout) {
        boolean added;
        boolean bl = added = this.globalSessionsWithTimeouts.put(sessionId, sessionTimeout) == null;
        if (this.localSessionsEnabled && added) {
            LOG.info("Adding global session 0x" + Long.toHexString(sessionId));
        }
        this.touchTable.get().put(sessionId, sessionTimeout);
        return added;
    }

    @Override
    public boolean addSession(long sessionId, int sessionTimeout) {
        boolean added;
        if (this.localSessionsEnabled && !this.isGlobalSession(sessionId)) {
            added = this.localSessionTracker.addSession(sessionId, sessionTimeout);
            if (this.isGlobalSession(sessionId)) {
                added = false;
                this.localSessionTracker.removeSession(sessionId);
            } else if (added) {
                LOG.info("Adding local session 0x" + Long.toHexString(sessionId));
            }
        } else {
            added = this.addGlobalSession(sessionId, sessionTimeout);
        }
        return added;
    }

    @Override
    public boolean touchSession(long sessionId, int sessionTimeout) {
        if (this.localSessionsEnabled) {
            if (this.localSessionTracker.touchSession(sessionId, sessionTimeout)) {
                return true;
            }
            if (!this.isGlobalSession(sessionId)) {
                return false;
            }
        }
        this.touchTable.get().put(sessionId, sessionTimeout);
        return true;
    }

    public Map<Long, Integer> snapshot() {
        return this.touchTable.getAndSet(new ConcurrentHashMap());
    }

    @Override
    public long createSession(int sessionTimeout) {
        if (this.localSessionsEnabled) {
            return this.localSessionTracker.createSession(sessionTimeout);
        }
        return this.nextSessionId.getAndIncrement();
    }

    @Override
    public void checkSession(long sessionId, Object owner) throws KeeperException.SessionExpiredException, KeeperException.SessionMovedException {
        block3: {
            if (this.localSessionTracker != null) {
                try {
                    this.localSessionTracker.checkSession(sessionId, owner);
                    return;
                }
                catch (KeeperException.UnknownSessionException e) {
                    if (this.isGlobalSession(sessionId)) break block3;
                    throw new KeeperException.SessionExpiredException();
                }
            }
        }
    }

    @Override
    public void setOwner(long sessionId, Object owner) throws KeeperException.SessionExpiredException {
        block3: {
            if (this.localSessionTracker != null) {
                try {
                    this.localSessionTracker.setOwner(sessionId, owner);
                    return;
                }
                catch (KeeperException.SessionExpiredException e) {
                    if (this.isGlobalSession(sessionId)) break block3;
                    throw e;
                }
            }
        }
    }

    @Override
    public void dumpSessions(PrintWriter pwriter) {
        if (this.localSessionTracker != null) {
            pwriter.print("Local ");
            this.localSessionTracker.dumpSessions(pwriter);
        }
        pwriter.print("Global Sessions(");
        pwriter.print(this.globalSessionsWithTimeouts.size());
        pwriter.println("):");
        TreeSet sessionIds = new TreeSet(this.globalSessionsWithTimeouts.keySet());
        Iterator iterator = sessionIds.iterator();
        while (iterator.hasNext()) {
            long sessionId = (Long)iterator.next();
            pwriter.print("0x");
            pwriter.print(Long.toHexString(sessionId));
            pwriter.print("\t");
            pwriter.print(this.globalSessionsWithTimeouts.get(sessionId));
            pwriter.println("ms");
        }
    }

    @Override
    public void setSessionClosing(long sessionId) {
        if (this.localSessionTracker != null) {
            this.localSessionTracker.setSessionClosing(sessionId);
        }
    }

    @Override
    public Map<Long, Set<Long>> getSessionExpiryMap() {
        return new HashMap<Long, Set<Long>>();
    }
}

