/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.aspectj.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.pulsar.shade.org.aspectj.apache.bcel.classfile.Attribute;
import org.apache.pulsar.shade.org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.apache.pulsar.shade.org.aspectj.apache.bcel.classfile.ConstantPool;

public final class ModulePackages
extends Attribute {
    private static int[] NO_PACKAGES = new int[0];
    private int[] packageIndices;

    public ModulePackages(ModulePackages c) {
        this(c.getNameIndex(), c.getLength(), c.getPackageIndices(), c.getConstantPool());
    }

    public ModulePackages(int nameIndex, int length, int[] packageIndices, ConstantPool cp) {
        super((byte)24, nameIndex, length, cp);
        this.setPackageIndices(packageIndices);
    }

    ModulePackages(int nameIndex, int length, DataInputStream stream, ConstantPool cp) throws IOException {
        this(nameIndex, length, (int[])null, cp);
        int packageIndicesCount = stream.readUnsignedShort();
        this.packageIndices = new int[packageIndicesCount];
        int i = 0;
        while (i < packageIndicesCount) {
            this.packageIndices[i] = stream.readUnsignedShort();
            ++i;
        }
    }

    @Override
    public void accept(ClassVisitor v) {
        v.visitModulePackages(this);
    }

    @Override
    public final void dump(DataOutputStream stream) throws IOException {
        super.dump(stream);
        stream.writeShort(this.packageIndices.length);
        int i = 0;
        while (i < this.packageIndices.length) {
            stream.writeShort(this.packageIndices[i]);
            ++i;
        }
    }

    public final int[] getPackageIndices() {
        return this.packageIndices;
    }

    public final void setPackageIndices(int[] packageIndices) {
        this.packageIndices = packageIndices == null ? NO_PACKAGES : packageIndices;
    }

    @Override
    public final String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.packageIndices.length) {
            buf.append(String.valueOf(this.cpool.getPackageName(this.packageIndices[i])) + "\n");
            ++i;
        }
        return buf.toString();
    }
}

