/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.aspectj.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.pulsar.shade.org.aspectj.apache.bcel.generic.ClassGenException;
import org.apache.pulsar.shade.org.aspectj.apache.bcel.generic.InstructionBranch;
import org.apache.pulsar.shade.org.aspectj.apache.bcel.generic.InstructionHandle;
import org.apache.pulsar.shade.org.aspectj.apache.bcel.util.ByteSequence;

public abstract class InstructionSelect
extends InstructionBranch {
    protected int[] match;
    protected int[] indices;
    protected InstructionHandle[] targets;
    protected int fixedLength;
    protected int matchLength;
    protected int padding = 0;
    protected short length;

    InstructionSelect(short opcode, int[] match, InstructionHandle[] targets, InstructionHandle target) {
        super(opcode, target);
        this.targets = targets;
        int i = 0;
        while (i < targets.length) {
            InstructionSelect.notifyTarget(null, targets[i], this);
            ++i;
        }
        this.match = match;
        this.matchLength = match.length;
        if (this.matchLength != targets.length) {
            throw new ClassGenException("Match and target array have not the same length");
        }
        this.indices = new int[this.matchLength];
    }

    protected int getTargetOffset(InstructionHandle target) {
        if (target == null) {
            throw new ClassGenException("Target of " + super.toString(true) + " is invalid null handle");
        }
        int t = target.getPosition();
        if (t < 0) {
            throw new ClassGenException("Invalid branch target position offset for " + super.toString(true) + ":" + t + ":" + target);
        }
        return t - this.positionOfThisInstruction;
    }

    @Override
    protected int updatePosition(int offset, int max_offset) {
        this.positionOfThisInstruction += offset;
        short old_length = this.length;
        this.padding = (4 - (this.positionOfThisInstruction + 1) % 4) % 4;
        this.length = (short)(this.fixedLength + this.padding);
        return this.length - old_length;
    }

    @Override
    public void dump(DataOutputStream out) throws IOException {
        out.writeByte(this.opcode);
        int i = 0;
        while (i < this.padding) {
            out.writeByte(0);
            ++i;
        }
        this.targetIndex = this.getTargetOffset();
        out.writeInt(this.targetIndex);
    }

    public InstructionSelect(short opcode, ByteSequence bytes) throws IOException {
        super(opcode);
        this.padding = (4 - bytes.getIndex() % 4) % 4;
        int i = 0;
        while (i < this.padding) {
            bytes.readByte();
            ++i;
        }
        this.targetIndex = bytes.readInt();
    }

    @Override
    public String toString(boolean verbose) {
        StringBuffer buf = new StringBuffer(super.toString(verbose));
        if (verbose) {
            int i = 0;
            while (i < this.matchLength) {
                String s = "null";
                if (this.targets[i] != null) {
                    s = this.targets[i].getInstruction().toString();
                }
                buf.append("(" + this.match[i] + ", " + s + " = {" + this.indices[i] + "})");
                ++i;
            }
        } else {
            buf.append(" ...");
        }
        return buf.toString();
    }

    public void setTarget(int i, InstructionHandle target) {
        InstructionSelect.notifyTarget(this.targets[i], target, this);
        this.targets[i] = target;
    }

    @Override
    public void updateTarget(InstructionHandle old_ih, InstructionHandle new_ih) {
        boolean targeted = false;
        if (this.targetInstruction == old_ih) {
            targeted = true;
            this.setTarget(new_ih);
        }
        int i = 0;
        while (i < this.targets.length) {
            if (this.targets[i] == old_ih) {
                targeted = true;
                this.setTarget(i, new_ih);
            }
            ++i;
        }
        if (!targeted) {
            throw new ClassGenException("Not targeting " + old_ih);
        }
    }

    @Override
    public boolean containsTarget(InstructionHandle ih) {
        if (this.targetInstruction == ih) {
            return true;
        }
        int i = 0;
        while (i < this.targets.length) {
            if (this.targets[i] == ih) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    void dispose() {
        super.dispose();
        int i = 0;
        while (i < this.targets.length) {
            this.targets[i].removeTargeter(this);
            ++i;
        }
    }

    public int[] getMatchs() {
        return this.match;
    }

    public int[] getIndices() {
        return this.indices;
    }

    @Override
    public boolean equals(Object other) {
        return this == other;
    }

    @Override
    public int hashCode() {
        return this.opcode * 37;
    }

    public InstructionHandle[] getTargets() {
        return this.targets;
    }

    @Override
    public int getLength() {
        return this.length;
    }
}

