/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.glassfish.jersey.server.model;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import org.apache.pulsar.shade.javax.inject.Singleton;
import org.apache.pulsar.shade.org.glassfish.jersey.internal.Errors;
import org.apache.pulsar.shade.org.glassfish.jersey.internal.inject.PerLookup;
import org.apache.pulsar.shade.org.glassfish.jersey.internal.inject.Providers;
import org.apache.pulsar.shade.org.glassfish.jersey.server.internal.LocalizationMessages;
import org.apache.pulsar.shade.org.glassfish.jersey.server.model.AbstractResourceModelVisitor;
import org.apache.pulsar.shade.org.glassfish.jersey.server.model.HandlerConstructor;
import org.apache.pulsar.shade.org.glassfish.jersey.server.model.Invocable;
import org.apache.pulsar.shade.org.glassfish.jersey.server.model.Parameter;
import org.apache.pulsar.shade.org.glassfish.jersey.server.model.ResourceMethodValidator;

class InvocableValidator
extends AbstractResourceModelVisitor {
    private static final Set<Class<?>> SCOPE_ANNOTATIONS = InvocableValidator.getScopeAnnotations();
    protected final Set<Class<?>> checkedClasses = new HashSet();

    InvocableValidator() {
    }

    private static Set<Class<?>> getScopeAnnotations() {
        HashSet scopeAnnotations = new HashSet();
        scopeAnnotations.add(Singleton.class);
        scopeAnnotations.add(PerLookup.class);
        return scopeAnnotations;
    }

    @Override
    public void visitInvocable(Invocable invocable) {
        Class<?> resClass = invocable.getHandler().getHandlerClass();
        if (resClass != null && !this.checkedClasses.contains(resClass)) {
            this.checkedClasses.add(resClass);
            boolean provider = Providers.isProvider(resClass);
            int counter = 0;
            for (Annotation annotation : resClass.getAnnotations()) {
                if (!SCOPE_ANNOTATIONS.contains(annotation.annotationType())) continue;
                ++counter;
            }
            if (counter == 0 && provider) {
                Errors.warning(resClass, LocalizationMessages.RESOURCE_IMPLEMENTS_PROVIDER(resClass, Providers.getProviderContracts(resClass)));
            } else if (counter > 1) {
                Errors.fatal(resClass, LocalizationMessages.RESOURCE_MULTIPLE_SCOPE_ANNOTATIONS(resClass));
            }
        }
    }

    public static boolean isSingleton(Class<?> resourceClass) {
        return resourceClass.isAnnotationPresent(Singleton.class) || Providers.isProvider(resourceClass) && !resourceClass.isAnnotationPresent(PerLookup.class);
    }

    @Override
    public void visitResourceHandlerConstructor(HandlerConstructor constructor) {
        Class<?> resClass = constructor.getConstructor().getDeclaringClass();
        boolean isSingleton = InvocableValidator.isSingleton(resClass);
        int paramCount = 0;
        for (Parameter p : constructor.getParameters()) {
            ResourceMethodValidator.validateParameter(p, constructor.getConstructor(), constructor.getConstructor().toGenericString(), Integer.toString(++paramCount), isSingleton);
        }
    }
}

