/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.utils;

import java.util.Stack;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.SimpleTextOutputStream;

public class StatsOutputStream
extends SimpleTextOutputStream {
    private final Stack<Boolean> separators = new Stack();

    public StatsOutputStream(ByteBuf buffer) {
        super(buffer);
    }

    public StatsOutputStream startObject() {
        this.checkSeparator();
        this.separators.push(Boolean.FALSE);
        this.write('{');
        return this;
    }

    public StatsOutputStream startObject(String key) {
        this.checkSeparator();
        this.write('\"').writeEncoded(key).write("\":{");
        this.separators.push(Boolean.FALSE);
        return this;
    }

    public StatsOutputStream endObject() {
        this.separators.pop();
        this.write('}');
        return this;
    }

    public StatsOutputStream startList() {
        this.checkSeparator();
        this.separators.push(Boolean.FALSE);
        this.write('[');
        return this;
    }

    public StatsOutputStream startList(String key) {
        this.checkSeparator();
        this.write('\"').writeEncoded(key).write("\":[");
        this.separators.push(Boolean.FALSE);
        return this;
    }

    public StatsOutputStream endList() {
        this.separators.pop();
        this.write(']');
        return this;
    }

    public StatsOutputStream writePair(String name, boolean value) {
        this.checkSeparator();
        this.write('\"').writeEncoded(name).write("\":").write(value);
        return this;
    }

    public StatsOutputStream writePair(String name, long n) {
        this.checkSeparator();
        this.write('\"').writeEncoded(name).write("\":").write(n);
        return this;
    }

    public StatsOutputStream writePair(String name, double d) {
        this.checkSeparator();
        this.write('\"').writeEncoded(name).write("\":").write(d);
        return this;
    }

    public StatsOutputStream writePair(String name, String s) {
        this.checkSeparator();
        this.write('\"').writeEncoded(name).write("\":\"").writeEncoded(s).write('\"');
        return this;
    }

    public StatsOutputStream writeItem(boolean value) {
        this.checkSeparator();
        super.write(value);
        return this;
    }

    public StatsOutputStream writeItem(long n) {
        this.checkSeparator();
        super.write(n);
        return this;
    }

    public StatsOutputStream writeItem(double d) {
        this.checkSeparator();
        super.write(d);
        return this;
    }

    StatsOutputStream writeItem(String s) {
        this.checkSeparator();
        this.write('\"').writeEncoded(s).write('\"');
        return this;
    }

    private void checkSeparator() {
        if (this.separators.isEmpty()) {
            return;
        }
        if (this.separators.peek() == Boolean.TRUE) {
            this.write(",");
        } else {
            this.separators.set(this.separators.size() - 1, Boolean.TRUE);
        }
    }
}

