/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v1;

import org.apache.pulsar.broker.admin.impl.ResourceQuotasBase;
import org.apache.pulsar.shade.io.swagger.annotations.Api;
import org.apache.pulsar.shade.io.swagger.annotations.ApiOperation;
import org.apache.pulsar.shade.io.swagger.annotations.ApiResponse;
import org.apache.pulsar.shade.io.swagger.annotations.ApiResponses;
import org.apache.pulsar.shade.javax.ws.rs.Consumes;
import org.apache.pulsar.shade.javax.ws.rs.DELETE;
import org.apache.pulsar.shade.javax.ws.rs.GET;
import org.apache.pulsar.shade.javax.ws.rs.POST;
import org.apache.pulsar.shade.javax.ws.rs.Path;
import org.apache.pulsar.shade.javax.ws.rs.PathParam;
import org.apache.pulsar.shade.javax.ws.rs.Produces;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.ResourceQuota;

@Path(value="/resource-quotas")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/resource-quotas", description="Quota admin APIs", tags={"resource-quotas"}, hidden=true)
public class ResourceQuotas
extends ResourceQuotasBase {
    @GET
    @Path(value="/{property}/{cluster}/{namespace}/{bundle}")
    @ApiOperation(hidden=true, value="Get resource quota of a namespace bundle.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public ResourceQuota getNamespaceBundleResourceQuota(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="bundle") String bundleRange) {
        this.validateNamespaceName(property, cluster, namespace);
        return this.internalGetNamespaceBundleResourceQuota(bundleRange);
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/{bundle}")
    @ApiOperation(hidden=true, value="Set resource quota on a namespace.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=409, message="Concurrent modification")})
    public void setNamespaceBundleResourceQuota(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="bundle") String bundleRange, ResourceQuota quota) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalSetNamespaceBundleResourceQuota(bundleRange, quota);
    }

    @DELETE
    @Path(value="/{property}/{cluster}/{namespace}/{bundle}")
    @ApiOperation(hidden=true, value="Remove resource quota for a namespace.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=409, message="Concurrent modification")})
    public void removeNamespaceBundleResourceQuota(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="bundle") String bundleRange) {
        this.validateNamespaceName(property, cluster, namespace);
        this.internalRemoveNamespaceBundleResourceQuota(bundleRange);
    }
}

