/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.rest;

import org.apache.pulsar.broker.rest.TopicsBase;
import org.apache.pulsar.shade.io.swagger.annotations.Api;
import org.apache.pulsar.shade.io.swagger.annotations.ApiOperation;
import org.apache.pulsar.shade.io.swagger.annotations.ApiParam;
import org.apache.pulsar.shade.io.swagger.annotations.ApiResponse;
import org.apache.pulsar.shade.io.swagger.annotations.ApiResponses;
import org.apache.pulsar.shade.javax.ws.rs.Consumes;
import org.apache.pulsar.shade.javax.ws.rs.DefaultValue;
import org.apache.pulsar.shade.javax.ws.rs.Encoded;
import org.apache.pulsar.shade.javax.ws.rs.POST;
import org.apache.pulsar.shade.javax.ws.rs.Path;
import org.apache.pulsar.shade.javax.ws.rs.PathParam;
import org.apache.pulsar.shade.javax.ws.rs.Produces;
import org.apache.pulsar.shade.javax.ws.rs.QueryParam;
import org.apache.pulsar.shade.javax.ws.rs.container.AsyncResponse;
import org.apache.pulsar.shade.javax.ws.rs.container.Suspended;
import org.apache.pulsar.websocket.data.ProducerMessages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(value="/persistent", description="Apis for produce,consume and ack message on topics.", tags={"topics"})
public class Topics
extends TopicsBase {
    private static final Logger log = LoggerFactory.getLogger(Topics.class);

    @POST
    @Path(value="/persistent/{tenant}/{namespace}/{topic}")
    @ApiOperation(value="Produce message to a persistent topic.", response=String.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=401, message="Client is not authorized to perform operation"), @ApiResponse(code=404, message="tenant/namespace/topic doesn't exit"), @ApiResponse(code=412, message="Namespace name is not valid"), @ApiResponse(code=500, message="Internal server error")})
    public void produceOnPersistentTopic(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, ProducerMessages producerMessages) {
        try {
            this.validateTopicName(tenant, namespace, encodedTopic);
            this.validateProducePermission();
            this.publishMessages(asyncResponse, producerMessages, authoritative);
        }
        catch (Exception e) {
            log.error("[{}] Failed to produce on topic {}", new Object[]{this.clientAppId(), this.topicName, e});
            this.resumeAsyncResponseExceptionally(asyncResponse, e);
        }
    }

    @POST
    @Path(value="/persistent/{tenant}/{namespace}/{topic}/partitions/{partition}")
    @ApiOperation(value="Produce message to a partition of a persistent topic.", response=String.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=401, message="Client is not authorized to perform operation"), @ApiResponse(code=404, message="tenant/namespace/topic doesn't exit"), @ApiResponse(code=412, message="Namespace name is not valid"), @ApiResponse(code=500, message="Internal server error")})
    public void produceOnPersistentTopicPartition(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Specify topic partition", required=true) @PathParam(value="partition") int partition, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, ProducerMessages producerMessages) {
        try {
            this.validateTopicName(tenant, namespace, encodedTopic);
            this.validateProducePermission();
            this.publishMessagesToPartition(asyncResponse, producerMessages, authoritative, partition);
        }
        catch (Exception e) {
            log.error("[{}] Failed to produce on topic {}", new Object[]{this.clientAppId(), this.topicName, e});
            this.resumeAsyncResponseExceptionally(asyncResponse, e);
        }
    }

    @POST
    @Path(value="/non-persistent/{tenant}/{namespace}/{topic}")
    @ApiOperation(value="Produce message to a persistent topic.", response=String.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=401, message="Client is not authorized to perform operation"), @ApiResponse(code=404, message="tenant/namespace/topic doesn't exit"), @ApiResponse(code=412, message="Namespace name is not valid"), @ApiResponse(code=500, message="Internal server error")})
    public void produceOnNonPersistentTopic(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, ProducerMessages producerMessages) {
        try {
            this.validateTopicName(tenant, namespace, encodedTopic);
            this.validateProducePermission();
            this.publishMessages(asyncResponse, producerMessages, authoritative);
        }
        catch (Exception e) {
            log.error("[{}] Failed to produce on topic {}", new Object[]{this.clientAppId(), this.topicName, e});
            this.resumeAsyncResponseExceptionally(asyncResponse, e);
        }
    }

    @POST
    @Path(value="/non-persistent/{tenant}/{namespace}/{topic}/partitions/{partition}")
    @ApiOperation(value="Produce message to a partition of a persistent topic.", response=String.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=401, message="Client is not authorized to perform operation"), @ApiResponse(code=404, message="tenant/namespace/topic doesn't exit"), @ApiResponse(code=412, message="Namespace name is not valid"), @ApiResponse(code=500, message="Internal server error")})
    public void produceOnNonPersistentTopicPartition(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Specify topic partition", required=true) @PathParam(value="partition") int partition, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, ProducerMessages producerMessages) {
        try {
            this.validateTopicName(tenant, namespace, encodedTopic);
            this.validateProducePermission();
            this.publishMessagesToPartition(asyncResponse, producerMessages, authoritative, partition);
        }
        catch (Exception e) {
            log.error("[{}] Failed to produce on topic {}", new Object[]{this.clientAppId(), this.topicName, e});
            this.resumeAsyncResponseExceptionally(asyncResponse, e);
        }
    }
}

