/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.pulsar.metadata.api.coordination.CoordinationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedIdGenerator {
    private final String prefix;
    private final long generatorInstanceId;
    private final AtomicLong counter;
    private static final Logger log = LoggerFactory.getLogger(DistributedIdGenerator.class);

    public DistributedIdGenerator(CoordinationService cs, String path, String prefix) throws Exception {
        this.prefix = prefix;
        this.counter = new AtomicLong(0L);
        this.generatorInstanceId = cs.getNextCounterValue(path).get();
        log.info("Broker distributed id generator started with instance id {}-{}", (Object)prefix, (Object)this.generatorInstanceId);
    }

    public String getNextId() {
        return String.format("%s-%d-%d", this.prefix, this.generatorInstanceId, this.counter.getAndIncrement());
    }
}

