/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import org.apache.pulsar.shade.io.netty.util.Recycler;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.Entry;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.MessageMetadata;

public class EntryWrapper {
    private Entry entry = null;
    private MessageMetadata metadata = new MessageMetadata();
    private boolean hasMetadata = false;
    private final Recycler.Handle<EntryWrapper> handle;
    private static final Recycler<EntryWrapper> RECYCLER = new Recycler<EntryWrapper>(){

        @Override
        protected EntryWrapper newObject(Recycler.Handle<EntryWrapper> handle) {
            return new EntryWrapper(handle);
        }
    };

    public static EntryWrapper get(Entry entry, MessageMetadata metadata) {
        EntryWrapper entryWrapper = RECYCLER.get();
        entryWrapper.entry = entry;
        if (metadata != null) {
            entryWrapper.hasMetadata = true;
            entryWrapper.metadata.copyFrom(metadata);
        }
        entryWrapper.metadata.copyFrom(metadata);
        return entryWrapper;
    }

    private EntryWrapper(Recycler.Handle<EntryWrapper> handle) {
        this.handle = handle;
    }

    public Entry getEntry() {
        return this.entry;
    }

    public MessageMetadata getMetadata() {
        return this.hasMetadata ? this.metadata : null;
    }

    public void recycle() {
        this.entry = null;
        this.hasMetadata = false;
        this.metadata.clear();
        this.handle.recycle(this);
    }
}

