/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.List;
import org.apache.pulsar.broker.service.RedeliveryTracker;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.Position;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.collections.ConcurrentLongLongPairHashMap;

public class InMemoryRedeliveryTracker
implements RedeliveryTracker {
    private ConcurrentLongLongPairHashMap trackerCache = ConcurrentLongLongPairHashMap.newBuilder().concurrencyLevel(1).expectedItems(256).autoShrink(true).build();

    @Override
    public int incrementAndGetRedeliveryCount(Position position) {
        PositionImpl positionImpl = (PositionImpl)position;
        ConcurrentLongLongPairHashMap.LongPair count = this.trackerCache.get(positionImpl.getLedgerId(), positionImpl.getEntryId());
        int newCount = (int)(count != null ? count.first + 1L : 1L);
        this.trackerCache.put(positionImpl.getLedgerId(), positionImpl.getEntryId(), newCount, 0L);
        return newCount;
    }

    @Override
    public int getRedeliveryCount(Position position) {
        PositionImpl positionImpl = (PositionImpl)position;
        ConcurrentLongLongPairHashMap.LongPair count = this.trackerCache.get(positionImpl.getLedgerId(), positionImpl.getEntryId());
        return (int)(count != null ? count.first : 0L);
    }

    @Override
    public void remove(Position position) {
        PositionImpl positionImpl = (PositionImpl)position;
        this.trackerCache.remove(positionImpl.getLedgerId(), positionImpl.getEntryId());
    }

    @Override
    public void removeBatch(List<Position> positions) {
        if (positions != null) {
            positions.forEach(this::remove);
        }
    }

    @Override
    public void clear() {
        this.trackerCache.clear();
    }

    @Override
    public boolean contains(Position position) {
        PositionImpl positionImpl = (PositionImpl)position;
        return this.trackerCache.containsKey(positionImpl.getLedgerId(), positionImpl.getEntryId());
    }

    @Override
    public void addIfAbsent(Position position) {
        PositionImpl positionImpl = (PositionImpl)position;
        this.trackerCache.putIfAbsent(positionImpl.getLedgerId(), positionImpl.getEntryId(), 0L, 0L);
    }
}

