/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.resource.usage;

import org.apache.pulsar.broker.service.resource.usage.LightProtoCodec;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;

public final class NetworkUsage {
    private long bytesPerPeriod;
    private static final int _BYTES_PER_PERIOD_FIELD_NUMBER = 1;
    private static final int _BYTES_PER_PERIOD_TAG = 8;
    private static final int _BYTES_PER_PERIOD_TAG_SIZE = LightProtoCodec.computeVarIntSize(8);
    private static final int _BYTES_PER_PERIOD_MASK = 1;
    private long messagesPerPeriod;
    private static final int _MESSAGES_PER_PERIOD_FIELD_NUMBER = 2;
    private static final int _MESSAGES_PER_PERIOD_TAG = 16;
    private static final int _MESSAGES_PER_PERIOD_TAG_SIZE = LightProtoCodec.computeVarIntSize(16);
    private static final int _MESSAGES_PER_PERIOD_MASK = 2;
    private int _bitField0;
    private static final int _REQUIRED_FIELDS_MASK0 = 3;
    private int _cachedSize;
    private ByteBuf _parsedBuffer;

    public boolean hasBytesPerPeriod() {
        return (this._bitField0 & 1) != 0;
    }

    public long getBytesPerPeriod() {
        if (!this.hasBytesPerPeriod()) {
            throw new IllegalStateException("Field 'bytesPerPeriod' is not set");
        }
        return this.bytesPerPeriod;
    }

    public NetworkUsage setBytesPerPeriod(long bytesPerPeriod) {
        this.bytesPerPeriod = bytesPerPeriod;
        this._bitField0 |= 1;
        this._cachedSize = -1;
        return this;
    }

    public NetworkUsage clearBytesPerPeriod() {
        this._bitField0 &= 0xFFFFFFFE;
        return this;
    }

    public boolean hasMessagesPerPeriod() {
        return (this._bitField0 & 2) != 0;
    }

    public long getMessagesPerPeriod() {
        if (!this.hasMessagesPerPeriod()) {
            throw new IllegalStateException("Field 'messagesPerPeriod' is not set");
        }
        return this.messagesPerPeriod;
    }

    public NetworkUsage setMessagesPerPeriod(long messagesPerPeriod) {
        this.messagesPerPeriod = messagesPerPeriod;
        this._bitField0 |= 2;
        this._cachedSize = -1;
        return this;
    }

    public NetworkUsage clearMessagesPerPeriod() {
        this._bitField0 &= 0xFFFFFFFD;
        return this;
    }

    public int writeTo(ByteBuf _b) {
        this.checkRequiredFields();
        int _writeIdx = _b.writerIndex();
        LightProtoCodec.writeVarInt(_b, 8);
        LightProtoCodec.writeVarInt64(_b, this.bytesPerPeriod);
        LightProtoCodec.writeVarInt(_b, 16);
        LightProtoCodec.writeVarInt64(_b, this.messagesPerPeriod);
        return _b.writerIndex() - _writeIdx;
    }

    public int getSerializedSize() {
        if (this._cachedSize > -1) {
            return this._cachedSize;
        }
        int _size = 0;
        _size += _BYTES_PER_PERIOD_TAG_SIZE;
        _size += LightProtoCodec.computeVarInt64Size(this.bytesPerPeriod);
        _size += _MESSAGES_PER_PERIOD_TAG_SIZE;
        this._cachedSize = _size += LightProtoCodec.computeVarInt64Size(this.messagesPerPeriod);
        return _size;
    }

    public void parseFrom(ByteBuf _buffer, int _size) {
        this.clear();
        int _endIdx = _buffer.readerIndex() + _size;
        block4: while (_buffer.readerIndex() < _endIdx) {
            int _tag = LightProtoCodec.readVarInt(_buffer);
            switch (_tag) {
                case 8: {
                    this._bitField0 |= 1;
                    this.bytesPerPeriod = LightProtoCodec.readVarInt64(_buffer);
                    continue block4;
                }
                case 16: {
                    this._bitField0 |= 2;
                    this.messagesPerPeriod = LightProtoCodec.readVarInt64(_buffer);
                    continue block4;
                }
            }
            LightProtoCodec.skipUnknownField(_tag, _buffer);
        }
        this.checkRequiredFields();
        this._parsedBuffer = _buffer;
    }

    private void checkRequiredFields() {
        if ((this._bitField0 & 3) != 3) {
            throw new IllegalStateException("Some required fields are missing");
        }
    }

    public NetworkUsage clear() {
        this._parsedBuffer = null;
        this._cachedSize = -1;
        this._bitField0 = 0;
        return this;
    }

    public NetworkUsage copyFrom(NetworkUsage _other) {
        this._cachedSize = -1;
        if (_other.hasBytesPerPeriod()) {
            this.setBytesPerPeriod(_other.bytesPerPeriod);
        }
        if (_other.hasMessagesPerPeriod()) {
            this.setMessagesPerPeriod(_other.messagesPerPeriod);
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] a = new byte[this.getSerializedSize()];
        ByteBuf b = Unpooled.wrappedBuffer(a).writerIndex(0);
        this.writeTo(b);
        return a;
    }

    public void parseFrom(byte[] a) {
        ByteBuf b = Unpooled.wrappedBuffer(a);
        this.parseFrom(b, b.readableBytes());
    }
}

