/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.pulsar.broker.stats.DimensionStats;
import org.apache.pulsar.shade.com.google.common.collect.Maps;
import org.apache.pulsar.shade.org.apache.pulsar.common.stats.Metrics;

public class BrokerOperabilityMetrics {
    private final List<Metrics> metricsList = new ArrayList<Metrics>();
    private final String localCluster;
    private final DimensionStats topicLoadStats;
    private final DimensionStats zkWriteLatencyStats;
    private final DimensionStats zkReadLatencyStats;
    private final String brokerName;
    private final LongAdder connectionTotalCreatedCount;
    private final LongAdder connectionCreateSuccessCount;
    private final LongAdder connectionCreateFailCount;
    private final LongAdder connectionTotalClosedCount;
    private final LongAdder connectionActive;

    public BrokerOperabilityMetrics(String localCluster, String brokerName) {
        this.localCluster = localCluster;
        this.topicLoadStats = new DimensionStats("topic_load_times", 60L);
        this.zkWriteLatencyStats = new DimensionStats("zk_write_latency", 60L);
        this.zkReadLatencyStats = new DimensionStats("zk_read_latency", 60L);
        this.brokerName = brokerName;
        this.connectionTotalCreatedCount = new LongAdder();
        this.connectionCreateSuccessCount = new LongAdder();
        this.connectionCreateFailCount = new LongAdder();
        this.connectionTotalClosedCount = new LongAdder();
        this.connectionActive = new LongAdder();
    }

    public List<Metrics> getMetrics() {
        this.generate();
        return this.metricsList;
    }

    private void generate() {
        this.metricsList.add(this.getTopicLoadMetrics());
        this.metricsList.add(this.getZkWriteLatencyMetrics());
        this.metricsList.add(this.getZkReadLatencyMetrics());
        this.metricsList.add(this.getConnectionMetrics());
    }

    public Metrics generateConnectionMetrics() {
        return this.getConnectionMetrics();
    }

    Metrics getConnectionMetrics() {
        Metrics rMetrics = Metrics.create(this.getDimensionMap("broker_connection"));
        rMetrics.put("brk_connection_created_total_count", this.connectionTotalCreatedCount.longValue());
        rMetrics.put("brk_connection_create_success_count", this.connectionCreateSuccessCount.longValue());
        rMetrics.put("brk_connection_create_fail_count", this.connectionCreateFailCount.longValue());
        rMetrics.put("brk_connection_closed_total_count", this.connectionTotalClosedCount.longValue());
        rMetrics.put("brk_active_connections", this.connectionActive.longValue());
        return rMetrics;
    }

    Map<String, String> getDimensionMap(String metricsName) {
        HashMap<String, String> dimensionMap = Maps.newHashMap();
        dimensionMap.put("broker", this.brokerName);
        dimensionMap.put("cluster", this.localCluster);
        dimensionMap.put("metric", metricsName);
        return dimensionMap;
    }

    Metrics getTopicLoadMetrics() {
        return this.getDimensionMetrics("topic_load_times", "topic_load", this.topicLoadStats);
    }

    Metrics getZkWriteLatencyMetrics() {
        return this.getDimensionMetrics("zk_write_latency", "zk_write", this.zkWriteLatencyStats);
    }

    Metrics getZkReadLatencyMetrics() {
        return this.getDimensionMetrics("zk_read_latency", "zk_read", this.zkReadLatencyStats);
    }

    Metrics getDimensionMetrics(String metricsName, String dimensionName, DimensionStats stats) {
        Metrics dMetrics = Metrics.create(this.getDimensionMap(metricsName));
        DimensionStats.DimensionStatsSnapshot statsSnapshot = stats.getSnapshot();
        dMetrics.put("brk_" + dimensionName + "_time_mean_ms", statsSnapshot.getMeanDimension());
        dMetrics.put("brk_" + dimensionName + "_time_median_ms", statsSnapshot.getMedianDimension());
        dMetrics.put("brk_" + dimensionName + "_time_75percentile_ms", statsSnapshot.getDimension75());
        dMetrics.put("brk_" + dimensionName + "_time_95percentile_ms", statsSnapshot.getDimension95());
        dMetrics.put("brk_" + dimensionName + "_time_99_percentile_ms", statsSnapshot.getDimension99());
        dMetrics.put("brk_" + dimensionName + "_time_99_9_percentile_ms", statsSnapshot.getDimension999());
        dMetrics.put("brk_" + dimensionName + "_time_99_99_percentile_ms", statsSnapshot.getDimension9999());
        dMetrics.put("brk_" + dimensionName + "_rate_s", statsSnapshot.getDimensionCount());
        return dMetrics;
    }

    public void reset() {
        this.metricsList.clear();
        this.topicLoadStats.reset();
        this.zkWriteLatencyStats.reset();
        this.zkReadLatencyStats.reset();
    }

    public void recordTopicLoadTimeValue(long topicLoadLatencyMs) {
        this.topicLoadStats.recordDimensionTimeValue(topicLoadLatencyMs, TimeUnit.MILLISECONDS);
    }

    public void recordZkWriteLatencyTimeValue(long topicLoadLatencyMs) {
        this.zkWriteLatencyStats.recordDimensionTimeValue(topicLoadLatencyMs, TimeUnit.MILLISECONDS);
    }

    public void recordZkReadLatencyTimeValue(long topicLoadLatencyMs) {
        this.zkReadLatencyStats.recordDimensionTimeValue(topicLoadLatencyMs, TimeUnit.MILLISECONDS);
    }

    public void recordConnectionCreate() {
        this.connectionTotalCreatedCount.increment();
        this.connectionActive.increment();
    }

    public void recordConnectionClose() {
        this.connectionTotalClosedCount.increment();
        this.connectionActive.decrement();
    }

    public void recordConnectionCreateSuccess() {
        this.connectionCreateSuccessCount.increment();
    }

    public void recordConnectionCreateFail() {
        this.connectionCreateFailCount.increment();
    }
}

