/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats;

import java.util.HashMap;
import org.apache.pulsar.shade.com.google.common.collect.Maps;
import org.apache.pulsar.shade.io.netty.util.Recycler;
import org.apache.pulsar.shade.org.apache.pulsar.common.stats.Metrics;

public class ReplicationMetrics {
    public double msgRateOut;
    public double msgThroughputOut;
    public double msgReplBacklog;
    public double maxMsgReplDelayInSeconds;
    public int connected;
    private final Recycler.Handle<ReplicationMetrics> recyclerHandle;
    private static final Recycler<ReplicationMetrics> RECYCLER = new Recycler<ReplicationMetrics>(){

        @Override
        protected ReplicationMetrics newObject(Recycler.Handle<ReplicationMetrics> handle) {
            return new ReplicationMetrics(handle);
        }
    };

    public void reset() {
        this.msgRateOut = 0.0;
        this.msgThroughputOut = 0.0;
        this.msgReplBacklog = 0.0;
        this.connected = 0;
        this.maxMsgReplDelayInSeconds = 0.0;
    }

    public static ReplicationMetrics get() {
        ReplicationMetrics replicationMetrics = RECYCLER.get();
        replicationMetrics.reset();
        return replicationMetrics;
    }

    private ReplicationMetrics(Recycler.Handle<ReplicationMetrics> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }

    public void recycle() {
        this.msgRateOut = -1.0;
        this.msgThroughputOut = -1.0;
        this.msgReplBacklog = -1.0;
        this.connected = -1;
        this.recyclerHandle.recycle(this);
    }

    public Metrics add(String namespace, String local, String remote) {
        HashMap<String, String> dimensionMap = Maps.newHashMap();
        dimensionMap.put("namespace", namespace);
        dimensionMap.put("from_cluster", local);
        dimensionMap.put("to_cluster", remote);
        Metrics dMetrics = Metrics.create(dimensionMap);
        dMetrics.put("brk_repl_out_rate", this.msgRateOut);
        dMetrics.put("brk_repl_out_tp_rate", this.msgThroughputOut);
        dMetrics.put("brk_replication_backlog", this.msgReplBacklog);
        dMetrics.put("brk_repl_is_connected", this.connected);
        dMetrics.put("brk_max_replication_delay_second", this.maxMsgReplDelayInSeconds);
        return dMetrics;
    }
}

