/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.pendingack.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.transaction.pendingack.PendingAckReplyCallBack;
import org.apache.pulsar.broker.transaction.pendingack.PendingAckStore;
import org.apache.pulsar.broker.transaction.pendingack.impl.MLPendingAckReplyCallBack;
import org.apache.pulsar.broker.transaction.pendingack.impl.PendingAckHandleImpl;
import org.apache.pulsar.broker.transaction.pendingack.proto.PendingAckMetadata;
import org.apache.pulsar.broker.transaction.pendingack.proto.PendingAckMetadataEntry;
import org.apache.pulsar.broker.transaction.pendingack.proto.PendingAckOp;
import org.apache.pulsar.broker.transaction.util.LogIndexLagBackoff;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.shade.com.google.common.collect.ComparisonChain;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.Entry;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.Position;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.shade.org.apache.commons.lang3.tuple.MutablePair;
import org.apache.pulsar.shade.org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.CommandAck;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.TopicName;
import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.SpscArrayQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLPendingAckStore
implements PendingAckStore {
    private final ManagedLedger managedLedger;
    private final ManagedCursor cursor;
    public static final String PENDING_ACK_STORE_SUFFIX = "__transaction_pending_ack";
    public static final String PENDING_ACK_STORE_CURSOR_NAME = "__pending_ack_state";
    private final SpscArrayQueue<Entry> entryQueue;
    private final PositionImpl lastConfirmedEntry;
    private PositionImpl currentLoadPosition;
    private final AtomicLong currentIndexLag = new AtomicLong(0L);
    private volatile long maxIndexLag;
    protected PositionImpl maxAckPosition = PositionImpl.earliest;
    private final LogIndexLagBackoff logIndexBackoff;
    private final ConcurrentSkipListMap<PositionImpl, PositionImpl> pendingAckLogIndex;
    private final ManagedCursor subManagedCursor;
    private static final Logger log = LoggerFactory.getLogger(MLPendingAckStore.class);

    public MLPendingAckStore(ManagedLedger managedLedger, ManagedCursor cursor, ManagedCursor subManagedCursor, long transactionPendingAckLogIndexMinLag) {
        this.managedLedger = managedLedger;
        this.cursor = cursor;
        this.currentLoadPosition = (PositionImpl)this.cursor.getMarkDeletedPosition();
        this.entryQueue = new SpscArrayQueue(2000);
        this.lastConfirmedEntry = (PositionImpl)managedLedger.getLastConfirmedEntry();
        this.pendingAckLogIndex = new ConcurrentSkipListMap();
        this.subManagedCursor = subManagedCursor;
        this.logIndexBackoff = new LogIndexLagBackoff(transactionPendingAckLogIndexMinLag, Long.MAX_VALUE, 1.0);
        this.maxIndexLag = this.logIndexBackoff.next(0);
    }

    @Override
    public void replayAsync(PendingAckHandleImpl pendingAckHandle, ExecutorService transactionReplayExecutor) {
        transactionReplayExecutor.execute(new PendingAckReplay(new MLPendingAckReplyCallBack(pendingAckHandle)));
    }

    private void readAsync(int numberOfEntriesToRead, AsyncCallbacks.ReadEntriesCallback readEntriesCallback) {
        this.cursor.asyncReadEntries(numberOfEntriesToRead, readEntriesCallback, System.nanoTime(), PositionImpl.latest);
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        final CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        this.cursor.asyncClose(new AsyncCallbacks.CloseCallback(){

            @Override
            public void closeComplete(Object ctx) {
                MLPendingAckStore.this.managedLedger.asyncClose(new AsyncCallbacks.CloseCallback(){

                    @Override
                    public void closeComplete(Object ctx) {
                        if (log.isDebugEnabled()) {
                            log.debug("[{}][{}] MLPendingAckStore closed successfully\uff01", (Object)MLPendingAckStore.this.managedLedger.getName(), ctx);
                        }
                        completableFuture.complete(null);
                    }

                    @Override
                    public void closeFailed(ManagedLedgerException exception, Object ctx) {
                        log.error("[{}][{}] MLPendingAckStore closed failed,exception={}", new Object[]{MLPendingAckStore.this.managedLedger.getName(), ctx, exception});
                        completableFuture.completeExceptionally(exception);
                    }
                }, ctx);
            }

            @Override
            public void closeFailed(ManagedLedgerException exception, Object ctx) {
                completableFuture.completeExceptionally(exception);
            }
        }, null);
        return completableFuture;
    }

    @Override
    public CompletableFuture<Void> appendIndividualAck(TxnID txnID, List<MutablePair<PositionImpl, Integer>> positions) {
        PendingAckMetadataEntry pendingAckMetadataEntry = new PendingAckMetadataEntry();
        pendingAckMetadataEntry.setPendingAckOp(PendingAckOp.ACK);
        pendingAckMetadataEntry.setAckType(CommandAck.AckType.Individual);
        ArrayList<PendingAckMetadata> pendingAckMetadataList = new ArrayList<PendingAckMetadata>();
        positions.forEach(positionIntegerMutablePair -> {
            PendingAckMetadata pendingAckMetadata = new PendingAckMetadata();
            PositionImpl position = (PositionImpl)positionIntegerMutablePair.getLeft();
            int batchSize = (Integer)positionIntegerMutablePair.getRight();
            if (((PositionImpl)positionIntegerMutablePair.getLeft()).getAckSet() != null) {
                for (long l : position.getAckSet()) {
                    pendingAckMetadata.addAckSet(l);
                }
            }
            pendingAckMetadata.setLedgerId(position.getLedgerId());
            pendingAckMetadata.setEntryId(position.getEntryId());
            pendingAckMetadata.setBatchSize(batchSize);
            pendingAckMetadataList.add(pendingAckMetadata);
        });
        pendingAckMetadataEntry.addAllPendingAckMetadatas(pendingAckMetadataList);
        return this.appendCommon(pendingAckMetadataEntry, txnID);
    }

    @Override
    public CompletableFuture<Void> appendCumulativeAck(TxnID txnID, PositionImpl position) {
        PendingAckMetadataEntry pendingAckMetadataEntry = new PendingAckMetadataEntry();
        pendingAckMetadataEntry.setPendingAckOp(PendingAckOp.ACK);
        pendingAckMetadataEntry.setAckType(CommandAck.AckType.Cumulative);
        PendingAckMetadata pendingAckMetadata = new PendingAckMetadata();
        if (position.getAckSet() != null) {
            for (long l : position.getAckSet()) {
                pendingAckMetadata.addAckSet(l);
            }
        }
        pendingAckMetadata.setLedgerId(position.getLedgerId());
        pendingAckMetadata.setEntryId(position.getEntryId());
        pendingAckMetadataEntry.addAllPendingAckMetadatas(Collections.singleton(pendingAckMetadata));
        return this.appendCommon(pendingAckMetadataEntry, txnID);
    }

    @Override
    public CompletableFuture<Void> appendCommitMark(TxnID txnID, CommandAck.AckType ackType) {
        PendingAckMetadataEntry pendingAckMetadataEntry = new PendingAckMetadataEntry();
        pendingAckMetadataEntry.setPendingAckOp(PendingAckOp.COMMIT);
        pendingAckMetadataEntry.setAckType(ackType);
        return this.appendCommon(pendingAckMetadataEntry, txnID);
    }

    @Override
    public CompletableFuture<Void> appendAbortMark(TxnID txnID, CommandAck.AckType ackType) {
        PendingAckMetadataEntry pendingAckMetadataEntry = new PendingAckMetadataEntry();
        pendingAckMetadataEntry.setPendingAckOp(PendingAckOp.ABORT);
        pendingAckMetadataEntry.setAckType(ackType);
        return this.appendCommon(pendingAckMetadataEntry, txnID);
    }

    private CompletableFuture<Void> appendCommon(final PendingAckMetadataEntry pendingAckMetadataEntry, final TxnID txnID) {
        final CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        pendingAckMetadataEntry.setTxnidLeastBits(txnID.getLeastSigBits());
        pendingAckMetadataEntry.setTxnidMostBits(txnID.getMostSigBits());
        int transactionMetadataEntrySize = pendingAckMetadataEntry.getSerializedSize();
        final ByteBuf buf = PulsarByteBufAllocator.DEFAULT.buffer(transactionMetadataEntrySize, transactionMetadataEntrySize);
        pendingAckMetadataEntry.writeTo(buf);
        this.managedLedger.asyncAddEntry(buf, new AsyncCallbacks.AddEntryCallback(){

            @Override
            public void addComplete(Position position, ByteBuf entryData, Object ctx) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}][{}] MLPendingAckStore message append success at {} txnId: {}, operation : {}", new Object[]{MLPendingAckStore.this.managedLedger.getName(), ctx, position, txnID, pendingAckMetadataEntry.getPendingAckOp()});
                }
                MLPendingAckStore.this.currentIndexLag.incrementAndGet();
                MLPendingAckStore.this.handleMetadataEntry((PositionImpl)position, pendingAckMetadataEntry);
                buf.release();
                completableFuture.complete(null);
                MLPendingAckStore.this.clearUselessLogData();
            }

            @Override
            public void addFailed(ManagedLedgerException exception, Object ctx) {
                log.error("[{}][{}] MLPendingAckStore message append fail exception : {}, operation : {}", new Object[]{MLPendingAckStore.this.managedLedger.getName(), ctx, exception, pendingAckMetadataEntry.getPendingAckOp()});
                if (exception instanceof ManagedLedgerException.ManagedLedgerAlreadyClosedException) {
                    MLPendingAckStore.this.managedLedger.readyToCreateNewLedger();
                }
                buf.release();
                completableFuture.completeExceptionally(new BrokerServiceException.PersistenceException(exception));
            }
        }, null);
        return completableFuture;
    }

    private void handleMetadataEntry(PositionImpl logPosition, PendingAckMetadataEntry pendingAckMetadataEntry) {
        if (pendingAckMetadataEntry.getPendingAckOp() != PendingAckOp.ABORT && pendingAckMetadataEntry.getPendingAckOp() != PendingAckOp.COMMIT) {
            Optional optional = pendingAckMetadataEntry.getPendingAckMetadatasList().stream().max((o1, o2) -> ComparisonChain.start().compare(o1.getLedgerId(), o2.getLedgerId()).compare(o1.getEntryId(), o2.getEntryId()).result());
            optional.ifPresent(pendingAckMetadata -> {
                PositionImpl nowPosition = PositionImpl.get(pendingAckMetadata.getLedgerId(), pendingAckMetadata.getEntryId());
                if (nowPosition.compareTo(this.maxAckPosition) > 0) {
                    this.maxAckPosition = nowPosition;
                }
                if (this.currentIndexLag.get() >= this.maxIndexLag) {
                    this.pendingAckLogIndex.compute(this.maxAckPosition, (thisPosition, otherPosition) -> logPosition);
                    this.maxIndexLag = this.logIndexBackoff.next(this.pendingAckLogIndex.size());
                    this.currentIndexLag.set(0L);
                }
            });
        }
    }

    private void clearUselessLogData() {
        if (!this.pendingAckLogIndex.isEmpty()) {
            PositionImpl deletePosition = null;
            while (!this.pendingAckLogIndex.isEmpty() && this.pendingAckLogIndex.firstKey() != null && this.subManagedCursor.getPersistentMarkDeletedPosition() != null && this.pendingAckLogIndex.firstEntry().getKey().compareTo((PositionImpl)this.subManagedCursor.getPersistentMarkDeletedPosition()) <= 0) {
                deletePosition = this.pendingAckLogIndex.remove(this.pendingAckLogIndex.firstKey());
            }
            if (deletePosition != null) {
                this.maxIndexLag = this.logIndexBackoff.next(this.pendingAckLogIndex.size());
                final PositionImpl finalDeletePosition = deletePosition;
                this.cursor.asyncMarkDelete(deletePosition, new AsyncCallbacks.MarkDeleteCallback(){

                    @Override
                    public void markDeleteComplete(Object ctx) {
                        if (log.isDebugEnabled()) {
                            log.debug("[{}] Transaction pending ack store mark delete position : [{}] success", (Object)MLPendingAckStore.this.managedLedger.getName(), (Object)finalDeletePosition);
                        }
                    }

                    @Override
                    public void markDeleteFailed(ManagedLedgerException exception, Object ctx) {
                        log.error("[{}] Transaction pending ack store mark delete position : [{}] fail!", new Object[]{MLPendingAckStore.this.managedLedger.getName(), finalDeletePosition, exception});
                    }
                }, null);
            }
        }
    }

    public CompletableFuture<ManagedLedger> getManagedLedger() {
        return CompletableFuture.completedFuture(this.managedLedger);
    }

    public static String getTransactionPendingAckStoreSuffix(String originTopicName, String subName) {
        return TopicName.get(originTopicName) + "-" + subName + PENDING_ACK_STORE_SUFFIX;
    }

    public static String getTransactionPendingAckStoreCursorName() {
        return PENDING_ACK_STORE_CURSOR_NAME;
    }

    class FillEntryQueueCallback
    implements AsyncCallbacks.ReadEntriesCallback {
        private volatile boolean isReadable = true;
        private final AtomicLong outstandingReadsRequests = new AtomicLong(0L);
        private static final int NUMBER_OF_PER_READ_ENTRY = 100;

        FillEntryQueueCallback() {
        }

        boolean fillQueue() {
            if (MLPendingAckStore.this.entryQueue.size() + 100 < MLPendingAckStore.this.entryQueue.capacity() && this.outstandingReadsRequests.get() == 0L && MLPendingAckStore.this.cursor.hasMoreEntries()) {
                this.outstandingReadsRequests.incrementAndGet();
                MLPendingAckStore.this.readAsync(100, this);
            }
            return this.isReadable;
        }

        @Override
        public void readEntriesComplete(final List<Entry> entries, Object ctx) {
            MLPendingAckStore.this.entryQueue.fill((MessagePassingQueue.Supplier)new MessagePassingQueue.Supplier<Entry>(){
                private int i = 0;

                public Entry get() {
                    Entry entry = (Entry)entries.get(this.i);
                    ++this.i;
                    return entry;
                }
            }, entries.size());
            this.outstandingReadsRequests.decrementAndGet();
        }

        @Override
        public void readEntriesFailed(ManagedLedgerException exception, Object ctx) {
            if (MLPendingAckStore.this.managedLedger.getConfig().isAutoSkipNonRecoverableData() && exception instanceof ManagedLedgerException.NonRecoverableLedgerException || exception instanceof ManagedLedgerException.ManagedLedgerFencedException || exception instanceof ManagedLedgerException.CursorAlreadyClosedException) {
                this.isReadable = false;
            }
            log.error("MLPendingAckStore of topic [{}] stat reply fail!", (Object)MLPendingAckStore.this.managedLedger.getName(), (Object)exception);
            this.outstandingReadsRequests.decrementAndGet();
        }
    }

    class PendingAckReplay
    implements Runnable {
        private final FillEntryQueueCallback fillEntryQueueCallback;
        private final PendingAckReplyCallBack pendingAckReplyCallBack;

        PendingAckReplay(PendingAckReplyCallBack pendingAckReplyCallBack) {
            this.fillEntryQueueCallback = new FillEntryQueueCallback();
            this.pendingAckReplyCallBack = pendingAckReplyCallBack;
        }

        @Override
        public void run() {
            try {
                if (MLPendingAckStore.this.cursor.isClosed()) {
                    this.pendingAckReplyCallBack.replayFailed(new ManagedLedgerException.CursorAlreadyClosedException("MLPendingAckStore cursor have been closed."));
                    log.warn("[{}] MLPendingAckStore cursor have been closed, close replay thread.", (Object)MLPendingAckStore.this.cursor.getManagedLedger().getName());
                    return;
                }
                while (MLPendingAckStore.this.lastConfirmedEntry.compareTo(MLPendingAckStore.this.currentLoadPosition) > 0 && this.fillEntryQueueCallback.fillQueue()) {
                    Entry entry = (Entry)MLPendingAckStore.this.entryQueue.poll();
                    if (entry != null) {
                        ByteBuf buffer = entry.getDataBuffer();
                        MLPendingAckStore.this.currentLoadPosition = PositionImpl.get(entry.getLedgerId(), entry.getEntryId());
                        PendingAckMetadataEntry pendingAckMetadataEntry = new PendingAckMetadataEntry();
                        pendingAckMetadataEntry.parseFrom(buffer, buffer.readableBytes());
                        MLPendingAckStore.this.currentIndexLag.incrementAndGet();
                        MLPendingAckStore.this.handleMetadataEntry(new PositionImpl(entry.getLedgerId(), entry.getEntryId()), pendingAckMetadataEntry);
                        this.pendingAckReplyCallBack.handleMetadataEntry(pendingAckMetadataEntry);
                        entry.release();
                        MLPendingAckStore.this.clearUselessLogData();
                        continue;
                    }
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        if (!Thread.interrupted()) continue;
                        log.error("[{}]Transaction pending replay thread interrupt!", (Object)MLPendingAckStore.this.managedLedger.getName(), (Object)e);
                    }
                }
            }
            catch (Exception e) {
                this.pendingAckReplyCallBack.replayFailed(e);
                log.error("[{}] Pending ack recover fail!", (Object)MLPendingAckStore.this.subManagedCursor.getManagedLedger().getName(), (Object)e);
                return;
            }
            this.pendingAckReplyCallBack.replayComplete();
        }
    }
}

