/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import java.io.IOException;
import org.apache.pulsar.shade.javax.servlet.Filter;
import org.apache.pulsar.shade.javax.servlet.FilterChain;
import org.apache.pulsar.shade.javax.servlet.FilterConfig;
import org.apache.pulsar.shade.javax.servlet.ServletException;
import org.apache.pulsar.shade.javax.servlet.ServletRequest;
import org.apache.pulsar.shade.javax.servlet.ServletResponse;
import org.apache.pulsar.shade.javax.servlet.http.HttpServletRequest;
import org.apache.pulsar.shade.javax.servlet.http.HttpServletResponse;

public class MaxRequestSizeFilter
implements Filter {
    private final long maxSize;

    public MaxRequestSizeFilter(long maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        long size = request.getContentLengthLong();
        if (size > this.maxSize || MaxRequestSizeFilter.isChunked(request)) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.sendError(400, "Bad Request");
        } else {
            chain.doFilter(request, response);
        }
    }

    private static boolean isChunked(ServletRequest request) {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest req = (HttpServletRequest)request;
            String encoding = req.getHeader("Transfer-Encoding");
            return encoding != null && encoding.contains("chunked");
        }
        return false;
    }

    @Override
    public void destroy() {
    }
}

