/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import java.io.IOException;
import org.apache.pulsar.shade.com.google.common.util.concurrent.RateLimiter;
import org.apache.pulsar.shade.io.prometheus.client.Counter;
import org.apache.pulsar.shade.javax.servlet.Filter;
import org.apache.pulsar.shade.javax.servlet.FilterChain;
import org.apache.pulsar.shade.javax.servlet.FilterConfig;
import org.apache.pulsar.shade.javax.servlet.ServletException;
import org.apache.pulsar.shade.javax.servlet.ServletRequest;
import org.apache.pulsar.shade.javax.servlet.ServletResponse;
import org.apache.pulsar.shade.javax.servlet.http.HttpServletResponse;

public class RateLimitingFilter
implements Filter {
    private final RateLimiter limiter;
    private static final Counter httpRejectedRequests = (Counter)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_broker_http_rejected_requests")).help("Counter of HTTP requests rejected by rate limiting")).register();

    public RateLimitingFilter(double rateLimit) {
        this.limiter = RateLimiter.create(rateLimit);
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.limiter.tryAcquire()) {
            chain.doFilter(request, response);
        } else {
            httpRejectedRequests.inc();
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.sendError(429, "Too Many Requests");
        }
    }

    @Override
    public void destroy() {
    }
}

