/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pulsar.client.admin.Bookies;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.shade.javax.ws.rs.client.Entity;
import org.apache.pulsar.shade.javax.ws.rs.client.InvocationCallback;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.BookieInfo;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.BookiesClusterInfo;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.BookiesRackConfiguration;

public class BookiesImpl
extends BaseResource
implements Bookies {
    private final WebTarget adminBookies;

    public BookiesImpl(WebTarget web, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.adminBookies = web.path("/admin/v2/bookies");
    }

    @Override
    public BookiesRackConfiguration getBookiesRackInfo() throws PulsarAdminException {
        try {
            return this.getBookiesRackInfoAsync().get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<BookiesClusterInfo> getBookiesAsync() {
        WebTarget path = this.adminBookies.path("all");
        final CompletableFuture<BookiesClusterInfo> future = new CompletableFuture<BookiesClusterInfo>();
        this.asyncGetRequest(path, new InvocationCallback<BookiesClusterInfo>(){

            @Override
            public void completed(BookiesClusterInfo bookies) {
                future.complete(bookies);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BookiesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public BookiesClusterInfo getBookies() throws PulsarAdminException {
        try {
            return this.getBookiesAsync().get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<BookiesRackConfiguration> getBookiesRackInfoAsync() {
        WebTarget path = this.adminBookies.path("racks-info");
        final CompletableFuture<BookiesRackConfiguration> future = new CompletableFuture<BookiesRackConfiguration>();
        this.asyncGetRequest(path, new InvocationCallback<BookiesRackConfiguration>(){

            @Override
            public void completed(BookiesRackConfiguration bookiesRackConfiguration) {
                future.complete(bookiesRackConfiguration);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BookiesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public BookieInfo getBookieRackInfo(String bookieAddress) throws PulsarAdminException {
        try {
            return this.getBookieRackInfoAsync(bookieAddress).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<BookieInfo> getBookieRackInfoAsync(String bookieAddress) {
        WebTarget path = this.adminBookies.path("racks-info").path(bookieAddress);
        final CompletableFuture<BookieInfo> future = new CompletableFuture<BookieInfo>();
        this.asyncGetRequest(path, new InvocationCallback<BookieInfo>(){

            @Override
            public void completed(BookieInfo bookieInfo) {
                future.complete(bookieInfo);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BookiesImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void deleteBookieRackInfo(String bookieAddress) throws PulsarAdminException {
        try {
            this.deleteBookieRackInfoAsync(bookieAddress).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<Void> deleteBookieRackInfoAsync(String bookieAddress) {
        WebTarget path = this.adminBookies.path("racks-info").path(bookieAddress);
        return this.asyncDeleteRequest(path);
    }

    @Override
    public void updateBookieRackInfo(String bookieAddress, String group, BookieInfo bookieInfo) throws PulsarAdminException {
        try {
            this.updateBookieRackInfoAsync(bookieAddress, group, bookieInfo).get(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e);
        }
        catch (TimeoutException e) {
            throw new PulsarAdminException.TimeoutException(e);
        }
    }

    @Override
    public CompletableFuture<Void> updateBookieRackInfoAsync(String bookieAddress, String group, BookieInfo bookieInfo) {
        WebTarget path = this.adminBookies.path("racks-info").path(bookieAddress).queryParam("group", group);
        return this.asyncPostRequest(path, Entity.entity(bookieInfo, "application/json"));
    }
}

