/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.BatcherBuilder;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.MessagePayloadFactory;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.api.schema.GenericSchema;
import org.apache.pulsar.client.api.schema.RecordSchemaBuilder;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.api.schema.SchemaDefinitionBuilder;
import org.apache.pulsar.shade.com.google.protobuf.GeneratedMessageV3;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.KeyValueEncodingType;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.SchemaInfoWithVersion;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.SchemaType;

public interface PulsarClientImplementationBinding {
    public <T> SchemaDefinitionBuilder<T> newSchemaDefinitionBuilder();

    public ClientBuilder newClientBuilder();

    public MessageId newMessageId(long var1, long var3, int var5);

    public MessageId newMessageIdFromByteArray(byte[] var1) throws IOException;

    public MessageId newMessageIdFromByteArrayWithTopic(byte[] var1, String var2) throws IOException;

    public Authentication newAuthenticationToken(String var1);

    public Authentication newAuthenticationToken(Supplier<String> var1);

    public Authentication newAuthenticationTLS(String var1, String var2);

    public Authentication createAuthentication(String var1, String var2) throws PulsarClientException.UnsupportedAuthenticationException;

    public Authentication createAuthentication(String var1, Map<String, String> var2) throws PulsarClientException.UnsupportedAuthenticationException;

    public Schema<byte[]> newBytesSchema();

    public Schema<String> newStringSchema();

    public Schema<String> newStringSchema(Charset var1);

    public Schema<Byte> newByteSchema();

    public Schema<Short> newShortSchema();

    public Schema<Integer> newIntSchema();

    public Schema<Long> newLongSchema();

    public Schema<Boolean> newBooleanSchema();

    public Schema<ByteBuffer> newByteBufferSchema();

    public Schema<Float> newFloatSchema();

    public Schema<Double> newDoubleSchema();

    public Schema<Date> newDateSchema();

    public Schema<Time> newTimeSchema();

    public Schema<Timestamp> newTimestampSchema();

    public Schema<Instant> newInstantSchema();

    public Schema<LocalDate> newLocalDateSchema();

    public Schema<LocalTime> newLocalTimeSchema();

    public Schema<LocalDateTime> newLocalDateTimeSchema();

    public <T> Schema<T> newAvroSchema(SchemaDefinition var1);

    public <T extends GeneratedMessageV3> Schema<T> newProtobufSchema(SchemaDefinition var1);

    public <T extends GeneratedMessageV3> Schema<T> newProtobufNativeSchema(SchemaDefinition var1);

    public <T> Schema<T> newJSONSchema(SchemaDefinition var1);

    public Schema<GenericRecord> newAutoConsumeSchema();

    public Schema<byte[]> newAutoProduceSchema();

    public Schema<byte[]> newAutoProduceSchema(Schema<?> var1);

    public Schema<byte[]> newAutoProduceValidatedAvroSchema(Object var1);

    public Schema<KeyValue<byte[], byte[]>> newKeyValueBytesSchema();

    public <K, V> Schema<KeyValue<K, V>> newKeyValueSchema(Schema<K> var1, Schema<V> var2, KeyValueEncodingType var3);

    public <K, V> Schema<KeyValue<K, V>> newKeyValueSchema(Class<K> var1, Class<V> var2, SchemaType var3);

    public Schema<?> getSchema(SchemaInfo var1);

    public GenericSchema<GenericRecord> getGenericSchema(SchemaInfo var1);

    public RecordSchemaBuilder newRecordSchemaBuilder(String var1);

    public KeyValueEncodingType decodeKeyValueEncodingType(SchemaInfo var1);

    public <K, V> SchemaInfo encodeKeyValueSchemaInfo(Schema<K> var1, Schema<V> var2, KeyValueEncodingType var3);

    public <K, V> SchemaInfo encodeKeyValueSchemaInfo(String var1, Schema<K> var2, Schema<V> var3, KeyValueEncodingType var4);

    public KeyValue<SchemaInfo, SchemaInfo> decodeKeyValueSchemaInfo(SchemaInfo var1);

    public String jsonifySchemaInfo(SchemaInfo var1);

    public String jsonifySchemaInfoWithVersion(SchemaInfoWithVersion var1);

    public String jsonifyKeyValueSchemaInfo(KeyValue<SchemaInfo, SchemaInfo> var1);

    public String convertKeyValueSchemaInfoDataToString(KeyValue<SchemaInfo, SchemaInfo> var1) throws IOException;

    public byte[] convertKeyValueDataStringToSchemaInfoSchema(byte[] var1) throws IOException;

    public BatcherBuilder newDefaultBatcherBuilder();

    public BatcherBuilder newKeyBasedBatcherBuilder();

    public MessagePayloadFactory newDefaultMessagePayloadFactory();

    public static byte[] getBytes(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        if (byteBuffer.hasArray() && byteBuffer.arrayOffset() == 0 && byteBuffer.array().length == byteBuffer.remaining()) {
            return byteBuffer.array();
        }
        byte[] array = new byte[byteBuffer.remaining()];
        byteBuffer.get(array);
        return array;
    }

    public SchemaInfo newSchemaInfoImpl(String var1, byte[] var2, SchemaType var3, long var4, Map<String, String> var6);
}

