/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.windowing.evictors;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.pulsar.functions.windowing.Event;
import org.apache.pulsar.functions.windowing.EvictionContext;
import org.apache.pulsar.functions.windowing.EvictionPolicy;
import org.apache.pulsar.shade.org.apache.commons.lang3.tuple.Pair;

public class WatermarkCountEvictionPolicy<T>
implements EvictionPolicy<T, Pair<Long, Long>> {
    protected final int threshold;
    protected final AtomicLong currentCount;
    private EvictionContext context;
    private static final AtomicLongFieldUpdater<WatermarkCountEvictionPolicy> PROCESSED_UPDATER = AtomicLongFieldUpdater.newUpdater(WatermarkCountEvictionPolicy.class, "processed");
    private volatile long processed;

    public WatermarkCountEvictionPolicy(int count) {
        this.threshold = count;
        this.currentCount = new AtomicLong();
    }

    @Override
    public EvictionPolicy.Action evict(Event<T> event) {
        EvictionPolicy.Action action;
        if (this.getContext() == null) {
            return EvictionPolicy.Action.STOP;
        }
        if (event.getTimestamp() <= this.getContext().getReferenceTime() && this.processed < this.currentCount.get()) {
            action = this.doEvict(event);
            if (action == EvictionPolicy.Action.PROCESS) {
                PROCESSED_UPDATER.incrementAndGet(this);
            }
        } else {
            action = EvictionPolicy.Action.KEEP;
        }
        return action;
    }

    private EvictionPolicy.Action doEvict(Event<T> event) {
        long curVal;
        while ((curVal = this.currentCount.get()) > (long)this.threshold) {
            if (!this.currentCount.compareAndSet(curVal, curVal - 1L)) continue;
            return EvictionPolicy.Action.EXPIRE;
        }
        return EvictionPolicy.Action.PROCESS;
    }

    @Override
    public void track(Event<T> event) {
    }

    @Override
    public EvictionContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(EvictionContext context) {
        this.context = context;
        if (context.getCurrentCount() != null) {
            this.currentCount.set(context.getCurrentCount());
        } else {
            this.currentCount.set(this.processed + context.getSlidingCount());
        }
        this.processed = 0L;
    }

    @Override
    public void reset() {
        this.processed = 0L;
    }

    @Override
    public Pair<Long, Long> getState() {
        return Pair.of(this.currentCount.get(), this.processed);
    }

    @Override
    public void restoreState(Pair<Long, Long> state) {
        this.currentCount.set(state.getLeft());
        this.processed = state.getRight();
    }

    public String toString() {
        return "WatermarkCountEvictionPolicy{} " + super.toString();
    }
}

